/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.print.localprint;

import com.agfa.pacs.listtext.print.IFilmBoxResolution;
import com.agfa.pacs.listtext.print.IFilmSize;
import com.agfa.pacs.listtext.print.IPrintContext;
import com.agfa.pacs.listtext.print.IPrintManagement;
import com.agfa.pacs.listtext.print.PrintColor;
import com.agfa.pacs.listtext.print.RenderingHintsUser;
import com.agfa.pacs.listtext.print.localprint.LocalPrintContext;
import com.agfa.pacs.listtext.print.localprint.jps.JPSFilmSessionMedium;
import com.agfa.pacs.listtext.print.localprint.jps.JPSFilmSessionResolution;
import com.agfa.pacs.listtext.print.mapper.MapperFilmSession;
import com.agfa.pacs.logging.ALogger;
import java.awt.RenderingHints;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.print.DocFlavor;
import javax.print.PrintService;
import javax.print.PrintServiceLookup;
import javax.print.attribute.HashPrintRequestAttributeSet;
import javax.print.attribute.standard.ColorSupported;
import javax.print.attribute.standard.Media;
import javax.print.attribute.standard.MediaPrintableArea;
import javax.print.attribute.standard.MediaSizeName;
import javax.print.attribute.standard.PrinterResolution;

public class LocalPrintManagement
implements IPrintManagement,
RenderingHintsUser {
    private PrintService printService;
    private RenderingHints renderingHints;
    private int copies = 1;
    private static final DocFlavor flavor = DocFlavor.SERVICE_FORMATTED.PAGEABLE;

    public LocalPrintManagement(PrintService printService, int n) {
        this.printService = printService;
        this.copies = n;
    }

    public void setRenderingHints(RenderingHints renderingHints) {
        this.renderingHints = renderingHints;
    }

    public RenderingHints getRenderingHints() {
        return this.renderingHints;
    }

    public IPrintContext printFilmSession(MapperFilmSession mapperFilmSession) {
        return new LocalPrintContext(this, this.printService, mapperFilmSession, this.copies);
    }

    public PrintColor[] getSupportedColors() {
        ColorSupported colorSupported = (ColorSupported)this.printService.getSupportedAttributeValues(ColorSupported.class, flavor, null);
        if (colorSupported == ColorSupported.NOT_SUPPORTED) {
            return new PrintColor[]{PrintColor.Gray};
        }
        if (colorSupported == ColorSupported.SUPPORTED) {
            return new PrintColor[]{PrintColor.Gray, PrintColor.Color};
        }
        return null;
    }

    public List<IFilmSize> getFilmSessionMedia() {
        Media[] mediaArray;
        try {
            mediaArray = (Media[])this.printService.getSupportedAttributeValues(Media.class, flavor, null);
        }
        catch (Exception exception) {
            ALogger.getLogger(LocalPrintManagement.class).error("Error in WinPrinter", (Throwable)exception);
            return Collections.emptyList();
        }
        ArrayList<IFilmSize> arrayList = new ArrayList<IFilmSize>();
        Media[] mediaArray2 = mediaArray;
        int n = mediaArray.length;
        int n2 = 0;
        while (n2 < n) {
            Media media = mediaArray2[n2];
            if (media instanceof MediaSizeName) {
                MediaSizeName mediaSizeName = (MediaSizeName)media;
                HashPrintRequestAttributeSet hashPrintRequestAttributeSet = new HashPrintRequestAttributeSet();
                hashPrintRequestAttributeSet.add(mediaSizeName);
                MediaPrintableArea[] mediaPrintableAreaArray = (MediaPrintableArea[])this.printService.getSupportedAttributeValues(MediaPrintableArea.class, flavor, hashPrintRequestAttributeSet);
                arrayList.add(new JPSFilmSessionMedium(mediaSizeName, mediaPrintableAreaArray[0]));
            }
            ++n2;
        }
        return arrayList;
    }

    public List<IFilmBoxResolution> getFilmSessionResolutions() {
        PrinterResolution[] printerResolutionArray = (PrinterResolution[])this.printService.getSupportedAttributeValues(PrinterResolution.class, flavor, null);
        ArrayList<IFilmBoxResolution> arrayList = new ArrayList<IFilmBoxResolution>();
        if (printerResolutionArray != null) {
            int n = 0;
            while (n < printerResolutionArray.length) {
                PrinterResolution printerResolution = printerResolutionArray[n];
                if (printerResolution.getCrossFeedResolution(100) == printerResolution.getFeedResolution(100)) {
                    arrayList.add(new JPSFilmSessionResolution(printerResolution));
                }
                ++n;
            }
        }
        return arrayList;
    }

    public static PrintService getDefaultPrintService() {
        return PrintServiceLookup.lookupDefaultPrintService();
    }

    public static PrintService[] getPrintServices() {
        return PrintServiceLookup.lookupPrintServices(flavor, null);
    }
}

