/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw.manager;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.data.GrowableBufferedInputStream;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.data.cache.DicomCacheFactory;
import com.agfa.pacs.data.shared.data.cache.IDicomCache;
import com.agfa.pacs.data.shared.dicom.UIDType;
import com.agfa.pacs.data.shared.dicom.UIDUtilities;
import com.agfa.pacs.data.shared.hw.IDicomParser;
import com.agfa.pacs.data.shared.hw.IDicomParserExtender;
import com.agfa.pacs.data.shared.pixel.CachedPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.util.OverlayUtils;
import com.agfa.pacs.exceptionhandler.ExceptionHandlerFactory;
import com.agfa.pacs.logging.ALogger;
import java.io.BufferedInputStream;
import java.io.ByteArrayOutputStream;
import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.Arrays;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.io.DicomInputHandler;
import org.dcm4che3.io.DicomInputStream;
import org.dcm4che3.io.DicomOutputStream;

public class InputStreamDicomDataReader
implements DicomInputHandler,
IDicomParser {
    protected static final ALogger log = ALogger.getLogger(InputStreamDicomDataReader.class);
    protected static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    protected static final IDicomCache dicomCache = DicomCacheFactory.getInstance().getDicomCache();
    private static final boolean FILTER_ALL_PRIVATE_TAGS = false;
    private static final String MPEG2_BASE = "1.2.840.10008.1.2.4.10";
    private static final int TIANI_TAG_GROUP = 0x290000;
    private static final int TIANI_TAG_GROUP1 = 0x710000;
    private static int[] requiredPrivateTags = null;
    private static final int INITIAL_CAPACITY = 128;
    protected InputStream inputStream;
    protected boolean cacheHeaderData = true;
    private boolean missingTransferSyntax = false;
    private boolean filterPrivateData = false;
    private boolean readingFMI = true;
    private boolean hasPostPixelData = false;
    protected int frame = 0;
    protected int frameNumber;
    protected int currentOffset;
    protected FragmentedPixelData fragmentedData = null;
    protected String instanceUID;
    protected String studyKey;
    protected String transferSyntaxUID;
    protected IDicomDataListener listener;
    protected int[] frameSelection = null;
    private IDicomParserExtender extender = null;

    public static synchronized void addRequiredPrivateTag(int n) {
        InputStreamDicomDataReader.addRequiredPrivateTagImpl(n);
    }

    private static synchronized void addRequiredPrivateTagImpl(int n) {
        if (requiredPrivateTags == null) {
            requiredPrivateTags = new int[]{n};
        } else {
            int n2 = 0;
            while (n2 < requiredPrivateTags.length) {
                if (requiredPrivateTags[n2] == n) {
                    return;
                }
                ++n2;
            }
            int[] nArray = Arrays.copyOf(requiredPrivateTags, requiredPrivateTags.length + 1);
            nArray[nArray.length - 1] = n;
            requiredPrivateTags = nArray;
        }
    }

    public InputStreamDicomDataReader(InputStream inputStream, String string, IDicomDataListener iDicomDataListener, boolean bl) {
        this.inputStream = inputStream;
        this.currentOffset = 0;
        this.listener = iDicomDataListener;
        this.instanceUID = string;
        this.filterPrivateData = false;
    }

    public void setExtender(IDicomParserExtender iDicomParserExtender) {
        this.extender = iDicomParserExtender;
        this.cacheHeaderData = false;
    }

    public long parse() {
        try {
            this.inputStream = this.cacheHeaderData ? new GrowableBufferedInputStream(this.inputStream) : new BufferedInputStream(this.inputStream, 32768);
            ImpaxEEDicomInputStream impaxEEDicomInputStream = this.transferSyntaxUID == null ? new ImpaxEEDicomInputStream(this.inputStream) : new ImpaxEEDicomInputStream(this.inputStream, this.transferSyntaxUID);
            impaxEEDicomInputStream.setDicomInputHandler(this);
            impaxEEDicomInputStream.readFileMetaInformation();
            this.readingFMI = false;
            Attributes attributes = new Attributes(impaxEEDicomInputStream.bigEndian(), 128);
            impaxEEDicomInputStream.readAttributes(attributes, -1, -1);
            attributes.trimToSize();
            if (this.frame == 0 && this.frameNumber == 0) {
                this.correctTransferSyntax(attributes, impaxEEDicomInputStream);
                String string = attributes.getString(524310);
                if (UIDUtilities.getBaseType((String)string) == UIDType.Image) {
                    log.error("Image without Pixel Data:" + this.instanceUID);
                }
                this.handleDicomDataAvailable(attributes, impaxEEDicomInputStream, false);
                this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Success, null);
            } else if (this.hasPostPixelData) {
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(0x800000);
                DicomOutputStream dicomOutputStream = new DicomOutputStream((OutputStream)byteArrayOutputStream, "1.2.840.10008.1.2.1");
                dicomOutputStream.writeDataset(attributes.createFileMetaInformation("1.2.840.10008.1.2.1"), attributes);
                dicomOutputStream.close();
                ByteArrayContainer byteArrayContainer = new ByteArrayContainer(byteArrayOutputStream.toByteArray());
                this.cacheDicomData(byteArrayContainer);
                Attributes attributes2 = new Attributes();
                int[] nArray = attributes.tags();
                int n = 0;
                while (n < nArray.length) {
                    if (nArray[n] > 2145386512) {
                        attributes2.addSelected(attributes, nArray, n, nArray.length);
                        break;
                    }
                    ++n;
                }
                if (attributes2.isEmpty()) {
                    attributes2 = null;
                }
                this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Success, attributes2);
            } else {
                this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Success, null);
            }
            return impaxEEDicomInputStream.getPosition();
        }
        catch (Exception exception) {
            ExceptionHandlerFactory.getInstance().handleException((Throwable)exception);
            this.listener.dicomDataError(this.instanceUID, "DicomInputStream problem", (Throwable)exception);
            this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Failed, null);
            return -1L;
        }
    }

    protected void handleDicomDataAvailable(Attributes attributes, DicomInputStream dicomInputStream, boolean bl) {
        if (attributes.isEmpty()) {
            this.listener.dicomDataError(this.instanceUID, "Network problem", null);
            this.listener.dicomDataFinished(this.instanceUID, IDicomDataListener.Status.Failed, null);
            return;
        }
        if (this.extender != null) {
            this.extender.handleDicomDataAvailable(this.instanceUID, attributes, dicomInputStream, bl);
        } else {
            this.studyKey = attributes.getString(0x20000D);
            OverlayUtils.extractBitmapOverlays((Attributes)attributes);
            if (this.cacheHeaderData) {
                ByteArrayContainer byteArrayContainer = ((GrowableBufferedInputStream)this.inputStream).getCurrentBuffer(bl, dicomInputStream.bigEndian());
                this.cacheDicomData(byteArrayContainer);
            }
        }
        this.listener.dicomDataAvailable(this.instanceUID, attributes, bl);
    }

    private void cacheDicomData(ByteArrayContainer byteArrayContainer) {
        if (this.missingTransferSyntax) {
            dicomCache.putDataset(this.studyKey, this.instanceUID, byteArrayContainer, this.transferSyntaxUID);
        } else {
            dicomCache.putDataset(this.studyKey, this.instanceUID, byteArrayContainer, null);
        }
    }

    protected void handlePixelDataAvailable(ByteArrayContainer byteArrayContainer, byte[] byArray, Attributes attributes) {
        try {
            CacheID cacheID = null;
            if (this.extender == null) {
                if (byteArrayContainer == null) {
                    byteArrayContainer = this.getContainer(byArray.length);
                    System.arraycopy(byArray, 0, byteArrayContainer.data, 0, byArray.length);
                }
                if (this.frameSelection != null) {
                    this.frame = this.frame * this.frameSelection[2] + this.frameSelection[0] - 1;
                }
                cacheID = dicomCache.putPixelDataInfo(this.studyKey, this.instanceUID, this.frame, byteArrayContainer);
            } else {
                cacheID = this.extender.handlePixelDataAvailable(this.instanceUID, this.frame, byteArrayContainer, byArray, attributes);
            }
            CachedPixelDataInfo cachedPixelDataInfo = new CachedPixelDataInfo(this.transferSyntaxUID, cacheID, attributes);
            this.listener.pixelDataAvailable(this.instanceUID, (IPixelDataInfo)cachedPixelDataInfo, this.frame);
            ++this.frame;
        }
        catch (Exception exception) {
            log.error("ERROR cannot add pixeldata " + this.instanceUID + " " + this.frame, (Throwable)exception);
            ++this.frame;
        }
    }

    protected ByteArrayContainer getContainer(int n) {
        int n2 = ByteArrayContainer.roundUpSize((int)n);
        byte[] byArray = cache.allocBytes((long)n2);
        if (byArray.length < n2) {
            log.error("Wrong size:" + byArray.length + "/" + n2);
            byArray = new byte[n2];
        }
        return new ByteArrayContainer(byArray, 0, n);
    }

    protected boolean performHeaderCaching() {
        return this.cacheHeaderData;
    }

    public void readValue(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        int n;
        VR vR;
        if (this.readingFMI) {
            dicomInputStream.readValue(dicomInputStream, attributes);
            return;
        }
        if (dicomInputStream.tag() == 2145386512 && dicomInputStream.level() == 0) {
            int n2;
            Object object;
            String string = attributes.getString(524312);
            if (string != null) {
                this.instanceUID = string;
            }
            if (attributes.contains(528740)) {
                this.cacheHeaderData = false;
                object = attributes.getNestedDataset(528740);
                string = object.getString(528743);
                this.frameSelection = object.getInts(528738);
                if (string != null) {
                    this.instanceUID = string;
                    attributes.setString(524312, VR.CS, this.instanceUID);
                }
            }
            this.correctTransferSyntax(attributes, dicomInputStream);
            this.handleDicomDataAvailable(attributes, dicomInputStream, true);
            try {
                if (attributes.containsValue(0x280008)) {
                    this.frameNumber = attributes.getInt(0x280008, 0);
                }
            }
            catch (Exception exception) {}
            if (dicomInputStream.length() == -1) {
                this.readFragmentedPixelData(dicomInputStream, attributes);
                return;
            }
            object = attributes.getString(131088);
            if (object != null && UIDUtilities.isTransferSyntaxType((String)object, (UIDType)UIDType.Encapsulated)) {
                this.readFragmentedPixelData(dicomInputStream, attributes);
                return;
            }
            int n3 = attributes.getInt(2621457, 0);
            int n4 = attributes.getInt(2621456, 0);
            int n5 = attributes.getInt(2621696, 0);
            int n6 = attributes.getInt(0x280002, 0);
            this.frameNumber = this.frameNumber == 0 ? 1 : this.frameNumber;
            String string2 = attributes.getString(2621444);
            int n7 = -1;
            n7 = "YBR_FULL_422".equals(string2) ? n3 * n4 * 2 : ("YBR_PARTIAL_422".equals(string2) ? n3 * n4 * 2 : n3 * n4 * n5 * n6 / 8);
            int n8 = dicomInputStream.length();
            if (this.frameNumber > 1) {
                if (dicomInputStream.vr() == VR.OW && attributes.bigEndian()) {
                    this.readOWMultiframe(dicomInputStream, attributes, n7);
                    n8 -= n7 * this.frameNumber;
                } else {
                    n2 = 0;
                    while (n2 < this.frameNumber) {
                        this.readMultiframe(dicomInputStream, attributes, n7);
                        n8 -= n7;
                        ++n2;
                    }
                }
            } else {
                this.readSingleFrame(dicomInputStream, attributes, n7, false);
                n8 -= n7;
            }
            if (n8 > 0) {
                n2 = 0;
                while (n2 < n8) {
                    dicomInputStream.read();
                    ++n2;
                }
                if (n8 > 1) {
                    log.warn("Contains longer pixel data as expected:" + this.instanceUID);
                }
            }
            return;
        }
        if (this.frame > 0) {
            this.hasPostPixelData = true;
        }
        if ((vR = InputStreamDicomDataReader.getVR(dicomInputStream)) == VR.SQ || dicomInputStream.length() == -1) {
            dicomInputStream.readValue(dicomInputStream, attributes);
        } else {
            n = dicomInputStream.tag();
            if (n < 0) {
                dicomInputStream.readValue(dicomInputStream, attributes);
            } else {
                attributes.initWithBytes(n, vR, dicomInputStream.readValue());
            }
        }
        if (this.filterPrivateData && dicomInputStream.level() == 0 && ((n = dicomInputStream.tag()) & 0x10000) != 0) {
            String string;
            int n9 = n & 0xFFFF0000;
            if ((n9 == 0x290000 || n9 == 0x710000) && "TIANI".equals(string = attributes.getString(n9 | 0x10))) {
                return;
            }
            boolean bl = false;
            if (requiredPrivateTags != null) {
                int n10 = 0;
                while (n10 < requiredPrivateTags.length) {
                    if (requiredPrivateTags[n10] == n) {
                        bl = true;
                        break;
                    }
                    ++n10;
                }
            }
            if (!bl) {
                attributes.remove(n);
            }
        }
    }

    private void correctTransferSyntax(Attributes attributes, DicomInputStream dicomInputStream) throws IOException {
        if (this.transferSyntaxUID == null) {
            Attributes attributes2 = dicomInputStream.readFileMetaInformation();
            if (attributes2 != null) {
                this.transferSyntaxUID = attributes2.getString(131088);
            }
            if (this.transferSyntaxUID == null) {
                this.transferSyntaxUID = "1.2.840.10008.1.2";
            }
        }
        attributes.setString(131088, VR.UI, this.transferSyntaxUID);
    }

    private static VR getVR(DicomInputStream dicomInputStream) {
        VR vR;
        VR vR2 = dicomInputStream.vr();
        if (dicomInputStream.tag() == 0x240024 && dicomInputStream instanceof ImpaxEEDicomInputStream && (vR = ((ImpaxEEDicomInputStream)dicomInputStream).getOriginalVR()) != vR2) {
            vR2 = vR;
        }
        return vR2;
    }

    private void readFragmentedPixelData(DicomInputStream dicomInputStream, Attributes attributes) throws IOException {
        boolean bl = true;
        while (true) {
            dicomInputStream.readHeader();
            if (dicomInputStream.tag() == -73728) {
                if (bl) {
                    this.readOffsetTable(dicomInputStream, dicomInputStream.length());
                    bl = false;
                    continue;
                }
                if (this.frameNumber > 1) {
                    this.readMultiframe(dicomInputStream, attributes, dicomInputStream.length());
                    if (this.transferSyntaxUID.startsWith(MPEG2_BASE)) {
                        this.frame = this.frameNumber;
                    }
                    if (this.frame < this.frameNumber) continue;
                    dicomInputStream.readHeader();
                    return;
                }
                this.readSingleFrame(dicomInputStream, attributes, dicomInputStream.length(), true);
                return;
            }
            if (this.fragmentedData != null && this.fragmentedData.dataCollector != null && this.frame + 1 == this.frameNumber) break;
        }
        this.handlePixelDataAvailable(null, this.fragmentedData.dataCollector.toByteArray(), attributes);
    }

    protected void readOWMultiframe(DicomInputStream dicomInputStream, Attributes attributes, int n) throws IOException {
        if (n % 2 == 0) {
            int n2 = 0;
            while (n2 < this.frameNumber) {
                ByteArrayContainer byteArrayContainer = this.getContainer(n);
                dicomInputStream.read(byteArrayContainer.data, 0, n);
                InputStreamDicomDataReader.swapByteArray(byteArrayContainer);
                this.handlePixelDataAvailable(byteArrayContainer, null, attributes);
                ++n2;
            }
        } else {
            byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)dicomInputStream.length());
            dicomInputStream.readFully(byArray);
            InputStreamDicomDataReader.swapByteArray(byArray);
            int n3 = 0;
            while (n3 < this.frameNumber) {
                ByteArrayContainer byteArrayContainer = this.getContainer(n);
                System.arraycopy(byArray, n3 * n, byteArrayContainer.data, 0, n);
                this.handlePixelDataAvailable(byteArrayContainer, null, attributes);
                ++n3;
            }
            DataCacheProviderFactory.getCache().free(byArray);
        }
    }

    private void readOffsetTable(DicomInputStream dicomInputStream, int n) throws IOException {
        if (n == 0) {
            return;
        }
        byte[] byArray = new byte[n];
        int n2 = 0;
        for (int i = 0; i != n; i += n2) {
            n2 = dicomInputStream.read(byArray, i, n - i);
            if (n2 > 0) {
                continue;
            }
            log.error("Error reading offset table");
            break;
        }
        ByteBuffer byteBuffer = ByteBuffer.wrap(byArray);
        byteBuffer.order(ByteOrder.LITTLE_ENDIAN);
        int n3 = byteBuffer.limit() / 4;
        int[] nArray = new int[n3];
        int n4 = 0;
        while (n4 < n3) {
            nArray[n4] = byteBuffer.getInt(n4 * 4);
            ++n4;
        }
        this.fragmentedData = new FragmentedPixelData(nArray);
    }

    protected void readMultiframe(DicomInputStream dicomInputStream, Attributes attributes, int n) throws IOException {
        if (this.fragmentedData != null) {
            if (this.frame + 1 < this.fragmentedData.offsetTable.length && this.currentOffset == this.fragmentedData.offsetTable[this.frame + 1]) {
                if (this.fragmentedData.dataCollector != null) {
                    this.handlePixelDataAvailable(null, this.fragmentedData.dataCollector.toByteArray(), attributes);
                }
                this.fragmentedData.dataCollector = new ByteArrayOutputStream();
            }
            byte[] byArray = DataCacheProviderFactory.getCache().allocBytes((long)n);
            dicomInputStream.readFully(byArray);
            this.fragmentedData.dataCollector.write(byArray);
            DataCacheProviderFactory.getCache().free(byArray);
            this.currentOffset += n + 8;
        } else {
            ByteArrayContainer byteArrayContainer = this.getContainer(n);
            dicomInputStream.readFully(byteArrayContainer.data, 0, n);
            this.handlePixelDataAvailable(byteArrayContainer, null, attributes);
        }
    }

    protected void readSingleFrame(DicomInputStream dicomInputStream, Attributes attributes, int n, boolean bl) throws IOException {
        ByteArrayContainer byteArrayContainer = this.getContainer(n);
        dicomInputStream.readFully(byteArrayContainer.data, 0, n);
        if (attributes.bigEndian() && dicomInputStream.vr() == VR.OW) {
            InputStreamDicomDataReader.swapByteArray(byteArrayContainer);
        }
        if (bl) {
            int n2;
            try {
                dicomInputStream.readHeader();
                n2 = dicomInputStream.tag();
            }
            catch (EOFException eOFException) {
                n2 = 0;
                log.error("instance stream damaged:" + this.instanceUID, (Throwable)eOFException);
            }
            if (n2 == -73728) {
                int n3 = dicomInputStream.length();
                ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(n + n3);
                byteArrayOutputStream.write(byteArrayContainer.data, 0, byteArrayContainer.length);
                DataCacheProviderFactory.getCache().free(byteArrayContainer.data);
                byte[] byArray = new byte[n3];
                do {
                    int n4 = 0;
                    n3 = dicomInputStream.length();
                    int n5 = byArray.length;
                    while (n4 < n3) {
                        int n6;
                        if (n4 + n5 > n3) {
                            n5 = n3 - n4;
                        }
                        if ((n6 = dicomInputStream.read(byArray, 0, n5)) < 0) {
                            throw new EOFException();
                        }
                        byteArrayOutputStream.write(byArray, 0, n6);
                        n4 += n6;
                    }
                    dicomInputStream.readHeader();
                } while (dicomInputStream.tag() == -73728);
                byteArrayOutputStream.close();
                this.handlePixelDataAvailable(null, byteArrayOutputStream.toByteArray(), attributes);
                byteArrayOutputStream = null;
                byArray = null;
                return;
            }
        }
        this.handlePixelDataAvailable(byteArrayContainer, null, attributes);
    }

    public static void swapByteArray(byte[] byArray) {
        if (byArray.length % 2 == 1) {
            throw new IllegalArgumentException("OW with uneven bytes");
        }
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n + 1];
            byArray[n + 1] = byArray[n];
            byArray[n] = by;
            n += 2;
        }
    }

    private static void swapByteArray(ByteArrayContainer byteArrayContainer) {
        byte[] byArray = byteArrayContainer.data;
        if ((byteArrayContainer.length & 1) == 1) {
            throw new IllegalArgumentException("OW with uneven bytes");
        }
        int n = 0;
        while (n < byteArrayContainer.length) {
            byte by = byArray[n + 1];
            byArray[n + 1] = byArray[n];
            byArray[n] = by;
            n += 2;
        }
    }

    public void setMissingTransferSyntaxUID(String string) {
        this.transferSyntaxUID = string;
        this.missingTransferSyntax = true;
    }

    public void readValue(DicomInputStream dicomInputStream, Sequence sequence) throws IOException {
        dicomInputStream.readValue(dicomInputStream, sequence);
    }

    public void readValue(DicomInputStream dicomInputStream, Fragments fragments) throws IOException {
        dicomInputStream.readValue(dicomInputStream, fragments);
    }

    public void startDataset(DicomInputStream dicomInputStream) throws IOException {
    }

    public void endDataset(DicomInputStream dicomInputStream) throws IOException {
    }

    protected static class FragmentedPixelData {
        public final int[] offsetTable;
        public ByteArrayOutputStream dataCollector = new ByteArrayOutputStream(16384);

        public FragmentedPixelData(int[] nArray) {
            this.offsetTable = nArray;
        }
    }

    private static class ImpaxEEDicomInputStream
    extends DicomInputStream {
        private VR origVR = null;

        public ImpaxEEDicomInputStream(InputStream inputStream) throws Exception {
            super(inputStream);
        }

        public ImpaxEEDicomInputStream(InputStream inputStream, String string) throws Exception {
            super(inputStream, string);
        }

        public VR getOriginalVR() {
            return this.origVR;
        }

        public void readHeader() throws IOException {
            super.readHeader();
            this.origVR = this.vr();
        }
    }
}

