/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.hw;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.hw.AbstractDicomRetriever;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.lw.ILoadableInfo;
import com.agfa.pacs.data.shared.pixel.CachedPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.tools.StreamUtil;
import java.io.InputStream;
import java.net.URL;
import java.net.URLConnection;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class LossyDicomRetriever
extends AbstractDicomRetriever {
    private IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private int imageQuality = (int)ConfigurationProviderFactory.getConfig().getLong("listtext.hw.lossyQualitySetting");
    private String imageQualityParam = null;

    public LossyDicomRetriever() {
        if (this.imageQuality != 0) {
            this.imageQualityParam = "&imageQuality=" + this.imageQuality;
        }
    }

    protected void processImpl(IDicomDataRequest iDicomDataRequest) {
        URL uRL = null;
        ILoadableInfo iLoadableInfo = iDicomDataRequest.getLoadableInfo();
        String string = iLoadableInfo.getSOPInstanceUID();
        try {
            String string2 = (String)iLoadableInfo.getSource().getIdentifier().getPropertiesOwner().properties().get("wadoURI");
            StringBuilder stringBuilder = new StringBuilder(string2);
            stringBuilder.append("?requestType=WADO&contentType=image/jpeg&studyUID=X&seriesUID=X&objectUID=");
            stringBuilder.append(string);
            if (this.imageQualityParam != null) {
                stringBuilder.append(this.imageQualityParam);
            }
            Attributes attributes = iDicomDataRequest.getObjectInfo().getAttributes();
            int n = attributes.getInt(0x280008, 1);
            Attributes attributes2 = new Attributes();
            attributes2.setProperty("LOSSY", (Object)Boolean.TRUE);
            attributes2.addSelected(attributes, new int[]{0x280002, 2621444, 2621456, 2621457});
            attributes2.setString(131088, VR.UI, "1.2.840.10008.1.2.4.50");
            attributes2.setInt(0x280002, VR.US, new int[]{3});
            attributes2.setString(2621444, VR.CS, PhotometricInterpretation.YBRPartial422.dicom());
            attributes2.setInt(2621696, VR.IS, new int[]{8});
            attributes2.setInt(2621697, VR.IS, new int[]{8});
            attributes2.setInt(2621698, VR.IS, new int[]{7});
            String string3 = String.valueOf(iLoadableInfo.getStudyUID()) + "LOSSY";
            int n2 = 0;
            while (n2 < n) {
                uRL = new URL(String.valueOf(stringBuilder.toString()) + "&frameNumber=" + (n2 + 1));
                URLConnection uRLConnection = uRL.openConnection();
                byte[] byArray = StreamUtil.readStream((InputStream)uRLConnection.getInputStream());
                StringBuilder stringBuilder2 = new StringBuilder();
                stringBuilder2.append(string);
                stringBuilder2.append('F');
                stringBuilder2.append(n2);
                CacheID cacheID = this.cache.createID(string3, stringBuilder2.toString(), 0);
                this.cache.addPersistentObject((Object)new ByteArrayContainer(byArray), ByteArrayContainer.class, cacheID);
                CachedPixelDataInfo cachedPixelDataInfo = new CachedPixelDataInfo("1.2.840.10008.1.2.4.50", cacheID, attributes2);
                iDicomDataRequest.pixelDataAvailable(string, (IPixelDataInfo)cachedPixelDataInfo, n2);
                ++n2;
            }
            iDicomDataRequest.dicomDataFinished(string, IDicomDataListener.Status.LossySuccess, null);
        }
        catch (Exception exception) {
            iDicomDataRequest.dicomDataError(iLoadableInfo.getSOPInstanceUID(), "Error", (Throwable)exception);
            return;
        }
    }
}

