/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.IComponentFactoryProvider;
import com.agfa.pacs.base.swing.StartupLFCheckpoint;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.logging.ALogger;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.DisplayMode;
import java.awt.Font;
import java.awt.GraphicsDevice;
import java.awt.Window;
import java.awt.image.DirectColorModel;
import javax.swing.SwingUtilities;
import javax.swing.UIDefaults;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import javax.swing.plaf.nimbus.NimbusLookAndFeel;

public class GUI {
    private static double scale = 1.0;
    private static double scaleDiagnostic = 1.0;
    private static boolean scalingDiagnosticComputed = false;

    public static boolean isOnColorMonitor(Window window) {
        if (window == null) {
            return true;
        }
        if (window.getGraphicsConfiguration().getColorModel().getColorSpace().getType() == 6) {
            return false;
        }
        int n = GUI.getBitDepth(window);
        if (n > 0 && n <= 10) {
            return false;
        }
        return window.getGraphicsConfiguration().getColorModel() instanceof DirectColorModel;
    }

    private static int getBitDepth(Window window) {
        DisplayMode displayMode;
        GraphicsDevice graphicsDevice = window.getGraphicsConfiguration().getDevice();
        if (graphicsDevice != null && (displayMode = graphicsDevice.getDisplayMode()) != null) {
            return displayMode.getBitDepth();
        }
        return -1;
    }

    public static void computeFactor(Dimension dimension, boolean bl, double d) {
        scale = GUI.computeFontScaleFactor(dimension.width, dimension.height, bl, d);
        if (Math.abs(scale - 1.0) > 0.01) {
            boolean bl2 = UIManager.getLookAndFeel() instanceof NimbusLookAndFeel;
            if (bl2) {
                EventUtil.invokeSynchronous(new Runnable(){

                    @Override
                    public void run() {
                        GUI.resetAgfaSystemFontDefaults(UIManager.getLookAndFeelDefaults(), scale, true);
                        Window[] windowArray = Window.getWindows();
                        if (windowArray != null) {
                            Window[] windowArray2 = windowArray;
                            int n = windowArray.length;
                            int n2 = 0;
                            while (n2 < n) {
                                Window window = windowArray2[n2];
                                SwingUtilities.updateComponentTreeUI(window);
                                ++n2;
                            }
                        }
                    }
                });
            } else {
                GUI.resetAgfaSystemFontDefaults(UIManager.getDefaults(), scale, false);
                GUI.resetAgfaComponentFontDefaults(UIManager.getDefaults(), scale, false);
            }
        }
        StartupLFCheckpoint.setLFReady();
    }

    public static synchronized void computeDiagnosticScalingFactor(Dimension dimension, boolean bl, double d) {
        if (scalingDiagnosticComputed) {
            return;
        }
        scaleDiagnostic = GUI.computeFontScaleFactor(dimension.width, dimension.height, bl, d);
        scalingDiagnosticComputed = true;
        ALogger.getLogger(GUI.class).info("Scaling factor for IA:" + scaleDiagnostic);
    }

    public static double getScaleFactor() {
        return scale;
    }

    public static double getScaleDiagnosticFactor() {
        return scaleDiagnostic;
    }

    public static Dimension getScaledDimension(int n, int n2) {
        return GUI.getScaledDimension(new Dimension(n, n2));
    }

    public static Dimension getScaledDiagnosticDimension(int n, int n2) {
        return GUI.getScaledDiagnosticDimension(new Dimension(n, n2));
    }

    public static Dimension getScaledDimension(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return new Dimension((int)((double)dimension.width * scale + 0.5), (int)((double)dimension.height * scale + 0.5));
    }

    public static Dimension getScaledDiagnosticDimension(Dimension dimension) {
        if (dimension == null) {
            return new Dimension(0, 0);
        }
        return new Dimension((int)((double)dimension.width * scaleDiagnostic + 0.5), (int)((double)dimension.height * scaleDiagnostic + 0.5));
    }

    public static int getScaledInt(int n) {
        return (int)((double)n * scale + 0.5);
    }

    public static int getScaledDiagnosticInt(int n) {
        return (int)((double)n * scaleDiagnostic + 0.5);
    }

    public static IComponentFactory getComponentFactory(Component component) {
        Component component2 = component;
        while (!(component2 instanceof IComponentFactoryProvider)) {
            component2 = component2.getParent();
        }
        return ((IComponentFactoryProvider)((Object)component2)).getComponentFactory();
    }

    private static double computeFontScaleFactor(int n, int n2, boolean bl, double d) {
        long l = n * n2;
        if (!bl && l > 3140610L) {
            d = Math.sqrt((double)l / 3140610.0);
            ALogger.getLogger(GUI.class).warn("Monitor very large, starting automatic font scaling:" + d);
            return d;
        }
        if (!bl) {
            return 1.0;
        }
        return d;
    }

    private static void resetAgfaSystemFontDefaults(UIDefaults uIDefaults, double d, boolean bl) {
        if (scale != 1.0) {
            Font font = UIManager.getFont("agfaFontSmall");
            Font font2 = UIManager.getFont("agfaFontDefault");
            Font font3 = UIManager.getFont("agfaFontLarge");
            Font font4 = UIManager.getFont("agfaFontXLarge");
            FontUIResource fontUIResource = new FontUIResource(font.deriveFont((float)((double)font.getSize() * d)));
            FontUIResource fontUIResource2 = new FontUIResource(font2.deriveFont((float)((double)font2.getSize() * d)));
            FontUIResource fontUIResource3 = new FontUIResource(font3.deriveFont((float)((double)font3.getSize() * d)));
            FontUIResource fontUIResource4 = new FontUIResource(font4.deriveFont((float)((double)font4.getSize() * d)));
            uIDefaults.put("agfaFontSmall", fontUIResource);
            uIDefaults.put("agfaFontDefault", fontUIResource2);
            uIDefaults.put("agfaFontLarge", fontUIResource3);
            uIDefaults.put("agfaFontXLarge", fontUIResource4);
            if (bl) {
                uIDefaults.put("defaultFont", fontUIResource2);
            }
        }
    }

    private static void resetAgfaComponentFontDefaults(UIDefaults uIDefaults, double d, boolean bl) {
        FontUIResource fontUIResource = (FontUIResource)uIDefaults.getFont("agfaFontDefault");
        uIDefaults.put("Button.font", fontUIResource);
        uIDefaults.put("ToggleButton.font", fontUIResource);
        uIDefaults.put("RadioButton.font", fontUIResource);
        uIDefaults.put("CheckBox.font", fontUIResource);
        uIDefaults.put("ColorChooser.font", fontUIResource);
        uIDefaults.put("ComboBox.font", fontUIResource);
        uIDefaults.put("InternalFrame.dialogFont", fontUIResource);
        uIDefaults.put("Label.font", fontUIResource);
        uIDefaults.put("List.font", fontUIResource);
        uIDefaults.put("MenuBar.font", fontUIResource);
        uIDefaults.put("MenuItem.font", fontUIResource);
        uIDefaults.put("RadioButtonMenuItem.font", fontUIResource);
        uIDefaults.put("CheckBoxMenuItem.font", fontUIResource);
        uIDefaults.put("Menu.font", fontUIResource);
        uIDefaults.put("PopuMenu.font", fontUIResource);
        uIDefaults.put("OptionPane.font", fontUIResource);
        uIDefaults.put("Panel.font", fontUIResource);
        uIDefaults.put("ProgressBar.font", fontUIResource);
        uIDefaults.put("ScrollPane.font", fontUIResource);
        uIDefaults.put("Viewport.font", fontUIResource);
        uIDefaults.put("Spinner.font", fontUIResource);
        uIDefaults.put("TabbedPane.font", fontUIResource);
        uIDefaults.put("Table.font", fontUIResource);
        uIDefaults.put("TableHeader.font", fontUIResource);
        uIDefaults.put("TextField.font", fontUIResource);
        uIDefaults.put("FormattedTextField.font", fontUIResource);
        uIDefaults.put("PasswordField.font", fontUIResource);
        uIDefaults.put("TextArea.font", fontUIResource);
        uIDefaults.put("TextPane.font", fontUIResource);
        uIDefaults.put("EditorPane.font", fontUIResource);
        uIDefaults.put("TitledBorder.font", fontUIResource);
        uIDefaults.put("ToolBar.font", fontUIResource);
        uIDefaults.put("ToolTip.font", fontUIResource);
        uIDefaults.put("Tree.font", fontUIResource);
    }
}

