/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.Frame;
import java.awt.GraphicsEnvironment;
import java.awt.HeadlessException;
import java.awt.Window;
import java.util.ArrayList;
import java.util.List;
import javax.swing.SwingUtilities;

public abstract class FocusUtil {
    private static boolean hasSingleMonitor = true;
    private static final boolean requestFocusOnImageLoading = ConfigurationProviderFactory.getConfig().getBoolean("listtext.service.requestFocusOnImageLoad");
    private static List<Window> ltaDockedWindows;

    static {
        try {
            if (!Product.isHeadless()) {
                hasSingleMonitor = GraphicsEnvironment.getLocalGraphicsEnvironment().getScreenDevices().length == 1;
            }
        }
        catch (HeadlessException headlessException) {
            ALogger.getLogger(FocusUtil.class).error("Error in initialisation", (Throwable)headlessException);
        }
        ltaDockedWindows = new ArrayList<Window>(3);
    }

    public static final boolean hasSingleMonitor() {
        return hasSingleMonitor;
    }

    public static void requestFocusAfterImageLoading(Window window, Window window2) {
        WindowAction windowAction = WindowAction.Deiconify;
        if (window != null && window.isFocused() || window2 != null && window2.isFocused()) {
            windowAction = WindowAction.RequestFocus;
        } else if (requestFocusOnImageLoading) {
            windowAction = WindowAction.RequestFocus;
        }
        FocusUtil.activateWindow(window, windowAction);
    }

    public static void activateWindow(final Window window, final WindowAction windowAction) {
        if (Product.isHeadless() || window == null) {
            return;
        }
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                Frame frame;
                if (window instanceof Frame && ((frame = (Frame)window).getExtendedState() & 1) == 1) {
                    frame.setExtendedState(frame.getExtendedState() ^ 1);
                }
                if (hasSingleMonitor || windowAction == WindowAction.RequestFocus || windowAction == WindowAction.ToFrontAndRequestFocus) {
                    if (windowAction != WindowAction.RequestFocus) {
                        window.toFront();
                    }
                    window.requestFocus();
                }
            }
        });
    }

    public static void addLTADockedWindow(Window window) {
        if (!ltaDockedWindows.contains(window)) {
            ltaDockedWindows.add(window);
        }
    }

    public static void clearLTADockedWindows() {
        ltaDockedWindows.clear();
    }

    public static void removeLTADockedWindow(Window window) {
        ltaDockedWindows.remove(window);
    }

    public static Window[] getLTADockedWindows() {
        return ltaDockedWindows.toArray(new Window[ltaDockedWindows.size()]);
    }

    private FocusUtil() {
    }

    public static enum WindowAction {
        Deiconify,
        RequestFocus,
        ToFrontAndRequestFocus;

    }
}

