/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.util;

import com.agfa.pacs.base.util.Product;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.logging.ALogger;
import java.awt.EventQueue;

public class EventUtil {
    private static final ALogger LOG = ALogger.getLogger(EventUtil.class);
    public static final String MAIN_APP_EVENT_PATH = "lta";
    public static final String KEYPRESS_PATH = "keypress";
    public static final int KEYPRESS_EVENT = EventEngineFactory.getInstance().getEventID("KEYPRESS");

    public static void invokeSynchronous(Runnable runnable) {
        if (!EventQueue.isDispatchThread() && !Product.isHeadless()) {
            try {
                EventQueue.invokeAndWait(runnable);
            }
            catch (Exception exception) {
                LOG.error("Execution error", (Throwable)exception);
            }
        } else if (runnable != null) {
            runnable.run();
        }
    }

    public static void invoke(Runnable runnable) {
        assert (runnable != null) : "Can not invoke a runnable that is null!";
        if (!EventQueue.isDispatchThread()) {
            EventQueue.invokeLater(runnable);
        } else {
            runnable.run();
        }
    }

    public static void invokeNotOnEDT(Runnable runnable) {
        assert (runnable != null);
        if (EventQueue.isDispatchThread()) {
            Thread thread = new Thread(runnable);
            thread.start();
        } else {
            runnable.run();
        }
    }

    private EventUtil() {
    }
}

