/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.studystatus.impl;

import com.agfa.pacs.base.swing.studystatus.IStudyStatusHandler;
import com.agfa.pacs.base.swing.studystatus.IStudyStatusHandlerProvider;
import com.agfa.pacs.base.swing.studystatus.IStudyStatusNotification;
import com.agfa.pacs.core.FactorySelector;
import java.lang.ref.WeakReference;
import java.util.Collections;
import java.util.Comparator;
import java.util.List;

public abstract class StatusProviderFactory {
    private static StatusProviderFactory implementation;
    private List<IStudyStatusHandlerProvider> orderedHandlers = null;
    private CachedHandler cache = null;

    public static synchronized StatusProviderFactory getInstance() {
        if (implementation == null) {
            StatusProviderFactory.initialize();
        }
        return implementation;
    }

    public IStudyStatusHandler getHandlerForObject(Object object, IStudyStatusNotification iStudyStatusNotification, boolean bl) {
        if (bl && this.cache != null && object == this.cache.cachedRequest.get()) {
            IStudyStatusHandler object2 = (IStudyStatusHandler)this.cache.cachedHandler.get();
            if (object2 != null) {
                object2.addNotificationListener(iStudyStatusNotification);
                return object2;
            }
            this.cache = null;
        }
        for (IStudyStatusHandlerProvider iStudyStatusHandlerProvider : this.getHandlerFactoriesOrdered()) {
            IStudyStatusHandler iStudyStatusHandler = iStudyStatusHandlerProvider.handle(object, iStudyStatusNotification, bl);
            if (iStudyStatusHandler == null) continue;
            if (bl) {
                this.cache = new CachedHandler(iStudyStatusHandler, object);
            }
            return iStudyStatusHandler;
        }
        return null;
    }

    public void init() {
        if (this.orderedHandlers == null) {
            this.orderedHandlers = this.getHandlerFactoriesInt();
            Collections.sort(this.orderedHandlers, new HandlerComparator());
        }
    }

    private List<IStudyStatusHandlerProvider> getHandlerFactoriesOrdered() {
        this.init();
        return this.orderedHandlers;
    }

    protected abstract List<IStudyStatusHandlerProvider> getHandlerFactoriesInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)StatusProviderFactory.class.getName()));
            implementation = (StatusProviderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + StatusProviderFactory.class.getName(), reflectiveOperationException);
        }
    }

    private static class CachedHandler {
        public final WeakReference<Object> cachedRequest;
        public final WeakReference<IStudyStatusHandler> cachedHandler;

        public CachedHandler(IStudyStatusHandler iStudyStatusHandler, Object object) {
            this.cachedHandler = new WeakReference<IStudyStatusHandler>(iStudyStatusHandler);
            this.cachedRequest = new WeakReference<Object>(object);
        }
    }

    private static class HandlerComparator
    implements Comparator<IStudyStatusHandlerProvider> {
        private HandlerComparator() {
        }

        @Override
        public int compare(IStudyStatusHandlerProvider iStudyStatusHandlerProvider, IStudyStatusHandlerProvider iStudyStatusHandlerProvider2) {
            return iStudyStatusHandlerProvider2.getPriority() - iStudyStatusHandlerProvider.getPriority();
        }
    }
}

