/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.progress.impl;

import com.agfa.pacs.base.swing.IComponentFactory;
import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import com.agfa.pacs.base.swing.progress.impl.ActivityState;
import com.agfa.pacs.base.swing.progress.impl.ActivityStateListener;
import com.agfa.pacs.base.swing.progress.impl.IActivityDisplayContainer;
import com.agfa.pacs.base.swing.util.EventUtil;
import com.agfa.pacs.base.swing.util.GUI;
import com.agfa.pacs.base.swing.util.IconFactory;
import com.agfa.pacs.data.shared.JobState;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Objects;
import javax.swing.AbstractAction;
import javax.swing.BorderFactory;
import javax.swing.Box;
import javax.swing.JButton;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.border.Border;

class ActivityDisplay
extends JPanel {
    protected static final int BUSY_SIZE = 32;
    protected final IComponentFactory componentFactory;
    private ActivityState activityState;
    private IActivityDisplayContainer dispContainer;
    private ActivityStateListener stateListener;
    protected JButton exitBtn;
    protected JXBusyLabel iconLabel;
    protected JLabel textLabel;
    private String lastText = null;
    protected Border displayBorder;

    ActivityDisplay(IComponentFactory iComponentFactory, ActivityState activityState) {
        this.componentFactory = iComponentFactory;
        this.stateListener = new InternalActivityStateListener();
        this.activityState = activityState != null ? activityState : new ActivityState();
        this.activityState.addActivityStateListener(this.stateListener);
        this.createComponents();
        this.initComponents();
        this.installLayout();
    }

    ActivityDisplay(IComponentFactory iComponentFactory) {
        this(iComponentFactory, null);
    }

    public ActivityState getActivityState() {
        return this.activityState;
    }

    public IActivityDisplayContainer getActivityDisplayContainer() {
        return this.dispContainer;
    }

    protected void setActivityDisplayContainer(IActivityDisplayContainer iActivityDisplayContainer) {
        this.dispContainer = iActivityDisplayContainer;
    }

    public void setHideable(boolean bl) {
        this.exitBtn.setVisible(bl);
        this.revalidate();
    }

    protected void createComponents() {
        this.displayBorder = BorderFactory.createCompoundBorder(BorderFactory.createRaisedBevelBorder(), BorderFactory.createEmptyBorder(5, 5, 5, 5));
        this.exitBtn = this.createExitButton();
        this.iconLabel = this.createBusyIconLabel();
        this.textLabel = this.createTextLabel();
    }

    protected void installLayout() {
        if (this.exitBtn.getIcon() != null) {
            int n = this.exitBtn.getIcon().getIconWidth();
            Dimension dimension = new Dimension(n + 4, n + 4);
            this.exitBtn.setMaximumSize(dimension);
            this.exitBtn.setMinimumSize(dimension);
            this.exitBtn.setPreferredSize(dimension);
        }
        this.setLayout(new BorderLayout());
        this.setBorder(this.displayBorder);
        Box box = Box.createHorizontalBox();
        box.add(Box.createHorizontalGlue());
        box.add(this.exitBtn);
        this.exitBtn.setAlignmentX(1.0f);
        this.add((Component)box, "North");
        box = Box.createVerticalBox();
        box.add(this.iconLabel);
        box.add(Box.createVerticalStrut(10));
        this.iconLabel.setAlignmentX(0.5f);
        this.add((Component)box, "Center");
        box = Box.createVerticalBox();
        box.add(this.textLabel);
        this.textLabel.setAlignmentX(0.5f);
        this.add((Component)box, "South");
    }

    protected void initComponents() {
        String string = this.activityState.getText();
        if (!Objects.equals(string, this.lastText)) {
            this.lastText = string;
            this.textLabel.setText(string);
        }
    }

    protected JXBusyLabel createBusyIconLabel() {
        Dimension dimension = GUI.getScaledDiagnosticDimension(32, 32);
        JXBusyLabel jXBusyLabel = new JXBusyLabel(dimension);
        if (this.componentFactory != null) {
            this.componentFactory.scaleFont(jXBusyLabel);
        }
        return jXBusyLabel;
    }

    protected JLabel createTextLabel() {
        JLabel jLabel = new JLabel();
        if (this.componentFactory != null) {
            this.componentFactory.scaleFont(jLabel);
        }
        return jLabel;
    }

    protected JButton createExitButton() {
        JButton jButton = new JButton(new ExitAction());
        if (this.componentFactory != null) {
            this.componentFactory.scaleFont(jButton);
        }
        return jButton;
    }

    void addHideListener(ActionListener actionListener) {
        this.exitBtn.addActionListener(actionListener);
    }

    private void updateDisplay() {
        EventUtil.invoke(new Runnable(){

            @Override
            public void run() {
                ActivityDisplay.this.updateDisplayInt();
            }
        });
    }

    protected void updateDisplayInt() {
        this.initComponents();
        this.updateIconAnimation();
    }

    private void updateIconAnimation() {
        JobState jobState = this.activityState.getState();
        if (jobState.isRunning()) {
            this.iconLabel.setBusy(true);
        } else {
            this.iconLabel.setBusy(false);
        }
    }

    int getScaledInt(int n) {
        if (this.componentFactory == null) {
            return n;
        }
        return this.componentFactory.scaleInt(n);
    }

    private class ExitAction
    extends AbstractAction {
        public ExitAction() {
            super(null, IconFactory.getScaledIcon("EXIT", ActivityDisplay.this.getScaledInt(10)));
        }

        @Override
        public void actionPerformed(ActionEvent actionEvent) {
            if (ActivityDisplay.this.dispContainer != null) {
                for (ActivityDisplay activityDisplay : ActivityDisplay.this.dispContainer.getActivityDisplays()) {
                    activityDisplay.setVisible(false);
                }
            }
        }
    }

    private class InternalActivityStateListener
    implements ActivityStateListener {
        private InternalActivityStateListener() {
        }

        @Override
        public void activityStateChanged(ActivityState activityState) {
            ActivityDisplay.this.updateDisplay();
        }
    }
}

