/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.layout;

import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Insets;
import java.awt.LayoutManager;
import javax.swing.BorderFactory;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;

public class RowLayout
implements LayoutManager {
    private int vgap;
    private boolean vstretch;
    private boolean hstretch;

    public RowLayout(int n, boolean bl, boolean bl2) {
        this.vgap = n >= 0 ? n : 0;
        this.vstretch = bl;
        this.hstretch = bl2;
    }

    public RowLayout(int n, boolean bl) {
        this(n, bl, true);
    }

    public RowLayout(int n) {
        this(n, false);
    }

    public RowLayout() {
        this(10);
    }

    public boolean isVerticalStretchEnabled() {
        return this.vstretch;
    }

    public void setVerticalStretchEnabled(boolean bl) {
        this.vstretch = bl;
    }

    public boolean isHorizontalStretchEnabled() {
        return this.hstretch;
    }

    public void setHorizontalStretchEnabled(boolean bl) {
        this.hstretch = bl;
    }

    @Override
    public void addLayoutComponent(String string, Component component) {
    }

    @Override
    public void removeLayoutComponent(Component component) {
    }

    @Override
    public Dimension minimumLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = n;
        int n4 = n2;
        Component[] componentArray = container.getComponents();
        int n5 = componentArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Component component = componentArray[n6];
            if (component.isVisible()) {
                Dimension dimension = component.getMinimumSize();
                n4 = (int)((double)n4 + (dimension.getHeight() + (double)this.vgap));
                n3 = (int)Math.max((double)n3, dimension.getWidth() + (double)n);
            }
            ++n6;
        }
        return new Dimension(n3, n4);
    }

    @Override
    public Dimension preferredLayoutSize(Container container) {
        Insets insets = container.getInsets();
        int n = insets.left + insets.right;
        int n2 = insets.top + insets.bottom;
        int n3 = n;
        int n4 = n2;
        Component[] componentArray = container.getComponents();
        int n5 = componentArray.length;
        int n6 = 0;
        while (n6 < n5) {
            Component component = componentArray[n6];
            if (component.isVisible()) {
                Dimension dimension = component.getPreferredSize();
                n4 = (int)((double)n4 + (dimension.getHeight() + (double)this.vgap));
                n3 = (int)Math.max((double)n3, dimension.getWidth() + (double)n);
            }
            ++n6;
        }
        return new Dimension(n3, n4);
    }

    @Override
    public void layoutContainer(Container container) {
        block7: {
            Component[] componentArray;
            int n;
            int n2;
            int n3;
            int n4;
            block6: {
                Insets insets = container.getInsets();
                n4 = insets.left;
                n3 = insets.top;
                n2 = container.getHeight() - insets.top - insets.bottom;
                n = container.getWidth() - insets.left - insets.right;
                componentArray = container.getComponents();
                if (this.vstretch) break block6;
                Component[] componentArray2 = componentArray;
                int n5 = componentArray.length;
                int n6 = 0;
                while (n6 < n5) {
                    Component component = componentArray2[n6];
                    if (component.isVisible()) {
                        Dimension dimension = component.getPreferredSize();
                        component.setBounds(n4, n3, this.hstretch ? n : dimension.width, dimension.height);
                        n3 += dimension.height + this.vgap;
                    }
                    ++n6;
                }
                break block7;
            }
            int n7 = 0;
            Component[] componentArray3 = componentArray;
            int n8 = componentArray.length;
            int n9 = 0;
            while (n9 < n8) {
                Component component = componentArray3[n9];
                if (component.isVisible()) {
                    ++n7;
                }
                ++n9;
            }
            if (n7 <= 0) break block7;
            int n10 = (n2 - (n7 - 1) * this.vgap) / n7;
            Component[] componentArray4 = componentArray;
            int n11 = componentArray.length;
            n8 = 0;
            while (n8 < n11) {
                Component component = componentArray4[n8];
                if (component.isVisible()) {
                    component.setBounds(n4, n3, this.hstretch ? n : component.getPreferredSize().width, n10);
                    n3 += n10 + this.vgap;
                }
                ++n8;
            }
        }
    }

    public static void main(String[] stringArray) {
        JFrame jFrame = new JFrame("RowLayout Test");
        jFrame.setDefaultCloseOperation(3);
        class RowLayoutTestPanel
        extends JPanel {
            RowLayoutTestPanel() {
                super(new RowLayout(20));
                this.add(new RowLayoutTestPanel(false, true));
                this.add(new RowLayoutTestPanel(true, true));
                this.add(new RowLayoutTestPanel(true, false));
                this.add(new RowLayoutTestPanel(false, false));
            }

            private RowLayoutTestPanel(boolean bl, boolean bl2) {
                super(new RowLayout(8, bl, bl2));
                this.setBorder(BorderFactory.createTitledBorder("vertical=" + bl + ", horizontal=" + bl2));
                int n = 0;
                while (n < 3) {
                    this.add(new JButton("" + n));
                    ++n;
                }
            }
        }
        jFrame.getContentPane().add(new JScrollPane(new RowLayoutTestPanel()));
        jFrame.setSize(400, 400);
        jFrame.setVisible(true);
    }
}

