/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.hardware;

import com.agfa.pacs.base.swing.hardware.impl.HardwareFeatures;
import com.agfa.pacs.base.swing.util.RestartNotifier;
import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.security.role.RoleManagerFactory;
import com.agfa.pacs.tools.ComputerName;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import javax.swing.JPanel;

public class HardwareRestrictions {
    private static final ALogger log = ALogger.getLogger(HardwareRestrictions.class);
    private static HardwareRestrictions instance = new HardwareRestrictions();
    private static String workstationRole = ConfigurationProviderFactory.getConfig().isSupportingRoles() ? "WORKSTATION" : null;
    private static String workstationName = ComputerName.getComputerId();
    private Map<String, Boolean> enabledFeatures = new HashMap<String, Boolean>();

    public static boolean isHardwarePresent(String string) {
        Boolean bl = HardwareRestrictions.instance.enabledFeatures.get(string);
        log.debug("Hardware restriction:" + string + " is " + bl);
        if (bl == null) {
            return false;
        }
        return bl;
    }

    public static boolean isHardwarePresent(String string, String string2) {
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(string).getNode("hardware");
        if (iConfigurationProvider.exists(string2)) {
            return iConfigurationProvider.getBoolean(string2);
        }
        return HardwareFeatures.getInstance().getHardwareFeatures().get(string2);
    }

    public static Set<String> getHardwareIds() {
        return new HashSet<String>(HardwareRestrictions.instance.enabledFeatures.keySet());
    }

    public static JPanel getHardwareAddOnPanel(String string, IConfigurationProvider iConfigurationProvider) {
        return HardwareFeatures.getInstance().getAdditionalConfigurationPanel(string, iConfigurationProvider);
    }

    public static void setHardwarePresent(String string, String string2, boolean bl) {
        if (string == null) {
            string = workstationRole;
        }
        if (string.equals(workstationRole)) {
            HardwareRestrictions.instance.enabledFeatures.put(string2, bl);
            RestartNotifier.setRestartRequired();
        } else if (workstationName != null && string.startsWith(RoleManagerFactory.getInstance().getWorkstationsRole().toString()) && string.contains(workstationName)) {
            HardwareRestrictions.instance.enabledFeatures.put(string2, bl);
            RestartNotifier.setRestartRequired();
        }
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getAdministrationFactory().getConfigForRole(string);
        iConfigurationProvider.getNode("hardware").setBoolean(string2, bl);
    }

    public static void setHardwarePresent(String string, boolean bl) {
        HardwareRestrictions.setHardwarePresent(null, string, bl);
    }

    private HardwareRestrictions() {
        Map<String, Boolean> map = HardwareFeatures.getInstance().getHardwareFeatures();
        IConfigurationProvider iConfigurationProvider = ConfigurationProviderFactory.getConfig().getNode("hardware");
        for (Map.Entry<String, Boolean> entry : map.entrySet()) {
            if (iConfigurationProvider.exists(entry.getKey())) {
                this.enabledFeatures.put(entry.getKey(), iConfigurationProvider.getBoolean(entry.getKey()));
                continue;
            }
            this.enabledFeatures.put(entry.getKey(), entry.getValue());
        }
    }
}

