/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.base.swing.busylabel;

import com.agfa.pacs.base.swing.busylabel.AbstractPainter;
import com.agfa.pacs.base.swing.busylabel.ColorUtil;
import com.agfa.pacs.base.swing.busylabel.JXBusyLabel;
import java.awt.Color;
import java.awt.Graphics2D;
import java.awt.Shape;
import java.awt.geom.Ellipse2D;
import java.awt.geom.Point2D;
import java.awt.geom.RoundRectangle2D;
import java.util.ArrayList;
import java.util.NoSuchElementException;

public class BusyPainter<T>
extends AbstractPainter<T> {
    private int frame = -1;
    private int points = 8;
    private Color baseColor = Color.LIGHT_GRAY;
    private Color highlightColor = Color.BLACK;
    private int trailLength = 4;
    private Shape pointShape;
    private Shape trajectory;
    private JXBusyLabel.Direction direction = JXBusyLabel.Direction.RIGHT;

    public BusyPainter() {
        this(26);
    }

    public BusyPainter(int n) {
        this(BusyPainter.getScaledDefaultPoint(n), BusyPainter.getScaledDefaultTrajectory(n));
    }

    protected static Shape getScaledDefaultTrajectory(int n) {
        return new Ellipse2D.Float(n * 8 / 26 / 2, n * 8 / 26 / 2, n - n * 8 / 26, n - n * 8 / 26);
    }

    protected static Shape getScaledDefaultPoint(int n) {
        return new RoundRectangle2D.Float(0.0f, 0.0f, n * 8 / 26, 4.0f, 4.0f, 4.0f);
    }

    public BusyPainter(Shape shape, Shape shape2) {
        this.init(shape, shape2, null, Color.BLACK);
    }

    protected void init(Shape shape, Shape shape2, Color color, Color color2) {
        this.baseColor = color;
        this.highlightColor = color2;
        this.pointShape = shape;
        this.trajectory = shape2;
    }

    /*
     * Unable to fully structure code
     */
    @Override
    protected void doPaint(Graphics2D var1_1, T var2_2, int var3_3, int var4_4) {
        var5_5 = this.trajectory.getPathIterator(null);
        var6_6 = new float[6];
        var7_7 = new Point2D.Float();
        var8_8 = new Point2D.Float();
        var10_9 = 0.0f;
        var11_10 = new ArrayList<float[]>();
        do {
            try {
                var9_11 = var5_5.currentSegment(var6_6);
            }
            catch (NoSuchElementException v0) {
                return;
            }
            if (var9_11 == 1 || var9_11 == 4 && (var8_8.x != var7_7.x || var8_8.y != var7_7.y)) {
                var12_12 = this.calcLine(var6_6, var7_7);
                var10_9 += var12_12;
                var11_10.add(new float[]{var12_12, 0.0f, 0.0f, 0.0f, 0.0f, var6_6[0], var6_6[1], var9_11});
                var7_7.x = var6_6[0];
                var7_7.y = var6_6[1];
            }
            if (var9_11 == 0) {
                var8_8.x = var7_7.x = var6_6[0];
                var8_8.y = var7_7.y = var6_6[1];
            }
            if (var9_11 == 3) {
                var12_12 = this.calcCube(var6_6, var7_7);
                var10_9 += var12_12;
                var11_10.add(new float[]{var12_12, var6_6[0], var6_6[1], var6_6[2], var6_6[3], var6_6[4], var6_6[5], var9_11});
                var7_7.x = var6_6[4];
                var7_7.y = var6_6[5];
            }
            if (var9_11 == 2) {
                var12_12 = this.calcLengthOfQuad(var6_6, var7_7);
                var10_9 += var12_12;
                var11_10.add(new float[]{var12_12, var6_6[0], var6_6[1], 0.0f, 0.0f, var6_6[2], var6_6[3], var9_11});
                var7_7.x = var6_6[2];
                var7_7.y = var6_6[3];
            }
            var5_5.next();
        } while (!var5_5.isDone());
        var12_12 = var10_9 / (float)this.getPoints();
        var13_13 = new ArrayList<Point2D.Float>();
        var13_13.add(new Point2D.Float(var8_8.x, var8_8.y));
        var14_14 = 0;
        var15_15 = (float[])var11_10.get(var14_14);
        var16_16 = var15_15[0];
        var17_17 = var12_12;
        var18_18 = new Point2D.Float(var8_8.x, var8_8.y);
        var19_19 = 1;
        ** GOTO lbl65
        {
            var8_8.x = var15_15[5];
            var8_8.y = var15_15[6];
            var15_15 = (float[])var11_10.get(++var14_14);
            var17_17 = var12_12 - var16_16;
            var16_16 += var15_15[0];
            do {
                if (var16_16 < var12_12) continue block3;
                var16_16 -= var12_12;
                var20_20 = this.calcPoint(var17_17, var8_8, var15_15, var3_3, var4_4);
                var13_13.add(var20_20);
                var18_18.x += var20_20.x;
                var18_18.y += var20_20.y;
                var17_17 += var12_12;
                ++var19_19;
lbl65:
                // 2 sources

            } while (var19_19 < this.getPoints());
        }
        var18_18.x = (float)var3_3 / 2.0f;
        var18_18.y = (float)var4_4 / 2.0f;
        var19_19 = 0;
        var1_1.translate(var18_18.x, var18_18.y);
        for (Point2D.Float var20_20 : var13_13) {
            this.drawAt(var1_1, var19_19++, var20_20, var18_18);
        }
        var1_1.translate(-var18_18.x, -var18_18.y);
    }

    private void drawAt(Graphics2D graphics2D, int n, Point2D.Float float_, Point2D.Float float_2) {
        graphics2D.setColor(this.calcFrameColor(n));
        this.paintRotatedCenteredShapeAtPoint(float_, float_2, graphics2D);
    }

    private void paintRotatedCenteredShapeAtPoint(Point2D.Float float_, Point2D.Float float_2, Graphics2D graphics2D) {
        Shape shape = this.getPointShape();
        double d = shape.getBounds().getHeight() / 2.0;
        double d2 = shape.getBounds().getWidth() / 2.0;
        double d3 = float_2.y - float_.y;
        double d4 = float_.x - float_2.x;
        double d5 = Math.signum(d3);
        double d6 = Math.signum(d4);
        d5 = d5 == 0.0 ? 1.0 : d5;
        d6 = d6 == 0.0 ? 1.0 : d6;
        d3 = Math.abs(d3);
        d4 = Math.abs(d4);
        double d7 = Math.atan(d3 / d4);
        d7 = d5 > 0.0 ? (d6 > 0.0 ? -d7 : -Math.PI + d7) : (d6 > 0.0 ? d7 : Math.PI - d7);
        double d8 = Math.sqrt(d3 * d3 + d4 * d4) - d2;
        double d9 = -d;
        graphics2D.rotate(d7);
        graphics2D.translate(d8, d9);
        graphics2D.fill(shape);
        graphics2D.translate(-d8, -d9);
        graphics2D.rotate(-d7);
    }

    private Point2D.Float calcPoint(float f, Point2D.Float float_, float[] fArray, int n, int n2) {
        Point2D.Float float_2 = new Point2D.Float();
        if (fArray[7] == 1.0f) {
            float f2 = fArray[5] - float_.x;
            float f3 = fArray[6] - float_.y;
            float f4 = fArray[0];
            float_2.x = float_.x + f2 * f / f4;
            float_2.y = float_.y + f3 * f / f4;
        } else if (fArray[7] == 2.0f) {
            Point2D.Float float_3 = new Point2D.Float(fArray[1] / (float)n, fArray[2] / (float)n2);
            Point2D.Float float_4 = new Point2D.Float(fArray[5] / (float)n, fArray[6] / (float)n2);
            Point2D.Float float_5 = new Point2D.Float(float_.x / (float)n, float_.y / (float)n2);
            float_2 = BusyPainter.getXY(f / fArray[0], float_5, float_3, float_4);
            float_2.x *= (float)n;
            float_2.y *= (float)n2;
        } else if (fArray[7] == 3.0f) {
            float f5 = Math.abs(float_.x - fArray[5]);
            float f6 = Math.abs(float_.y - fArray[6]);
            float f7 = Math.abs(float_.x - fArray[1]) / f5;
            float f8 = Math.abs(float_.y - fArray[2]) / f6;
            float f9 = Math.abs(float_.x - fArray[3]) / f5;
            float f10 = Math.abs(float_.y - fArray[4]) / f6;
            float_2 = this.getXY(f / fArray[0], f7, f8, f9, f10);
            float f11 = float_.x - fArray[5];
            float f12 = float_.y - fArray[6];
            float_2.x = float_.x - float_2.x * f11;
            float_2.y = float_.y - float_2.y * f12;
        }
        return float_2;
    }

    private float calcLine(float[] fArray, Point2D.Float float_) {
        float f = float_.x - fArray[0];
        float f2 = float_.y - fArray[1];
        float f3 = (float)Math.sqrt(f * f + f2 * f2);
        return f3;
    }

    private float calcCube(float[] fArray, Point2D.Float float_) {
        float f = Math.abs(float_.x - fArray[4]);
        float f2 = Math.abs(float_.y - fArray[5]);
        float f3 = Math.abs(float_.x - fArray[0]) / f;
        float f4 = Math.abs(float_.y - fArray[1]) / f2;
        float f5 = Math.abs(float_.x - fArray[2]) / f;
        float f6 = Math.abs(float_.y - fArray[3]) / f2;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.01f;
        while (f10 <= 1.0f) {
            Point2D.Float float_2 = this.getXY(f10, f3, f4, f5, f6);
            f7 += (float)Math.sqrt((float_2.x - f8) * (float_2.x - f8) + (float_2.y - f9) * (float_2.y - f9));
            f8 = float_2.x;
            f9 = float_2.y;
            f10 += 0.01f;
        }
        f10 = (Math.abs(f) + Math.abs(f2)) / 2.0f * f7;
        return f10;
    }

    private float calcLengthOfQuad(float[] fArray, Point2D.Float float_) {
        Point2D.Float float_2 = new Point2D.Float(fArray[0], fArray[1]);
        Point2D.Float float_3 = new Point2D.Float(fArray[2], fArray[3]);
        float f = Math.abs(float_.x - float_2.x);
        float f2 = Math.abs(float_.y - float_2.y);
        float f3 = Math.abs(float_.x - float_3.x);
        float f4 = Math.abs(float_.y - float_3.y);
        float f5 = Math.max(f, f3);
        float f6 = Math.max(f2, f4);
        float_2.x = f / f5;
        float_2.y = f2 / f6;
        float_3.x = f3 / f5;
        float_3.y = f4 / f6;
        float f7 = 0.0f;
        float f8 = 0.0f;
        float f9 = 0.0f;
        float f10 = 0.01f;
        while (f10 <= 1.0f) {
            Point2D.Float float_4 = BusyPainter.getXY(f10, new Point2D.Float(0.0f, 0.0f), float_2, float_3);
            f7 += (float)Math.sqrt((float_4.x - f8) * (float_4.x - f8) + (float_4.y - f9) * (float_4.y - f9));
            f8 = float_4.x;
            f9 = float_4.y;
            f10 += 0.01f;
        }
        f10 = Math.abs(fArray[2] - float_.x);
        float f11 = Math.abs(fArray[3] - float_.y);
        float f12 = (float)Math.sqrt(f10 * f10 + f11 * f11);
        return f7 * f12;
    }

    private Point2D.Float getXY(float f, float f2, float f3, float f4, float f5) {
        float f6 = 1.0f - f;
        float f7 = 3.0f * f * (f6 * f6);
        float f8 = 3.0f * (f * f) * f6;
        float f9 = f * f * f;
        Point2D.Float float_ = new Point2D.Float(f7 * f2 + f8 * f4 + f9, f7 * f3 + f8 * f5 + f9);
        return float_;
    }

    public static Point2D.Float getXY(float f, Point2D.Float float_, Point2D.Float float_2, Point2D.Float float_3) {
        float f2 = 1.0f - f;
        float f3 = f2 * f2;
        float f4 = 2.0f * f * f2;
        float f5 = f * f;
        Point2D.Float float_4 = new Point2D.Float(f3 * float_.x + f4 * float_2.x + f5 * float_3.x, f3 * float_.y + f4 * float_2.y + f5 * float_3.y);
        return float_4;
    }

    private Color calcFrameColor(int n) {
        if (this.frame == -1) {
            return this.getBaseColor();
        }
        int n2 = 0;
        while (n2 < this.getTrailLength()) {
            if (this.direction == JXBusyLabel.Direction.RIGHT && n == (this.frame - n2 + this.getPoints()) % this.getPoints()) {
                float f = 1.0f - (float)(this.getTrailLength() - n2) / (float)this.getTrailLength();
                return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f);
            }
            if (this.direction == JXBusyLabel.Direction.LEFT && n == (this.frame + n2) % this.getPoints()) {
                float f = (float)n2 / (float)this.getTrailLength();
                return ColorUtil.interpolate(this.getBaseColor(), this.getHighlightColor(), f);
            }
            ++n2;
        }
        return this.getBaseColor();
    }

    public int getFrame() {
        return this.frame;
    }

    public void setFrame(int n) {
        this.frame = n;
    }

    public Color getBaseColor() {
        return this.baseColor;
    }

    public void setBaseColor(Color color) {
        Color color2 = this.getBaseColor();
        this.baseColor = color;
        this.firePropertyChange("baseColor", color2, this.getBaseColor());
    }

    public Color getHighlightColor() {
        return this.highlightColor;
    }

    public void setHighlightColor(Color color) {
        Color color2 = this.getHighlightColor();
        this.highlightColor = color;
        this.firePropertyChange("highlightColor", color2, this.getHighlightColor());
    }

    public int getPoints() {
        return this.points;
    }

    public void setPoints(int n) {
        int n2 = this.getPoints();
        this.points = n;
        this.firePropertyChange("points", n2, this.getPoints());
    }

    public int getTrailLength() {
        return this.trailLength;
    }

    public void setTrailLength(int n) {
        int n2 = this.getTrailLength();
        this.trailLength = n;
        this.firePropertyChange("trailLength", n2, this.getTrailLength());
    }

    public final Shape getPointShape() {
        return this.pointShape;
    }

    public final void setPointShape(Shape shape) {
        Shape shape2 = this.getPointShape();
        this.pointShape = shape;
        if (this.getPointShape() != shape2 && this.getPointShape() != null && !this.getPointShape().equals(shape2)) {
            this.firePropertyChange("pointShape", shape2, this.getPointShape());
        }
    }

    public final Shape getTrajectory() {
        return this.trajectory;
    }

    public final void setTrajectory(Shape shape) {
        Shape shape2 = this.getTrajectory();
        this.trajectory = shape;
        if (this.getTrajectory() != shape2 && this.getTrajectory() != null && !this.getTrajectory().equals(shape2)) {
            this.firePropertyChange("trajectory", shape2, this.getTrajectory());
        }
    }

    public void setDirection(JXBusyLabel.Direction direction) {
        JXBusyLabel.Direction direction2 = this.getDirection();
        this.direction = direction;
        if (this.getDirection() != direction2 && this.getDirection() != null && !this.getDirection().equals((Object)direction2)) {
            this.firePropertyChange("direction", (Object)direction2, (Object)this.getDirection());
        }
    }

    public JXBusyLabel.Direction getDirection() {
        return this.direction;
    }
}

