/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.valuemapping.IPatientBodyData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.PatientSex;
import com.agfa.pacs.data.shared.valuemapping.SUVData;

public enum StandardizedUptakeValueMethod implements IStandardizedUptakeValueMethod
{
    BodyWeight("bw", Unit.G_PER_ML){

        @Override
        public boolean isValidGender(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public boolean isValidWeight(IPatientBodyData iPatientBodyData) {
            return !SUVData.isInvalid(iPatientBodyData.getPatientWeight());
        }

        @Override
        public boolean isValidHeight(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            return iPatientBodyData.getPatientWeight() * 1000.0;
        }
    }
    ,
    BodySurfaceArea("bsa", Unit.CM2_PER_ML){

        @Override
        public boolean isValidGender(IPatientBodyData iPatientBodyData) {
            return true;
        }

        @Override
        public boolean isValidWeight(IPatientBodyData iPatientBodyData) {
            return !SUVData.isInvalid(iPatientBodyData.getPatientWeight());
        }

        @Override
        public boolean isValidHeight(IPatientBodyData iPatientBodyData) {
            return !SUVData.isInvalid(iPatientBodyData.getPatientHeight());
        }

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            return Math.pow(iPatientBodyData.getPatientWeight(), 0.425) * Math.pow(iPatientBodyData.getPatientHeight(), 0.725) * 71.84;
        }
    }
    ,
    LeanBodyMass("lbm", Unit.G_PER_ML){

        @Override
        public boolean isValidGender(IPatientBodyData iPatientBodyData) {
            return iPatientBodyData.getPatientSex() == PatientSex.Male || iPatientBodyData.getPatientSex() == PatientSex.Female;
        }

        @Override
        public boolean isValidWeight(IPatientBodyData iPatientBodyData) {
            return !SUVData.isInvalid(iPatientBodyData.getPatientWeight());
        }

        @Override
        public boolean isValidHeight(IPatientBodyData iPatientBodyData) {
            return !SUVData.isInvalid(iPatientBodyData.getPatientHeight());
        }

        @Override
        public double getPatientSizeFactor(IPatientBodyData iPatientBodyData) {
            double d;
            double d2;
            if (iPatientBodyData.getPatientHeight() == 0.0) {
                return 0.0;
            }
            switch (iPatientBodyData.getPatientSex()) {
                case Male: {
                    d2 = 1.1;
                    d = 128.0;
                    break;
                }
                case Female: {
                    d2 = 1.07;
                    d = 148.0;
                    break;
                }
                default: {
                    return 0.0;
                }
            }
            return 1000.0 * (d2 * iPatientBodyData.getPatientWeight() - d * StandardizedUptakeValueMethod.squared(iPatientBodyData.getPatientWeight() / iPatientBodyData.getPatientHeight()));
        }
    };

    private final String abbreviation;
    private final Unit unit;

    private StandardizedUptakeValueMethod(String string2, Unit unit) {
        this.abbreviation = string2;
        this.unit = unit;
    }

    private static double squared(double d) {
        return d * d;
    }

    @Override
    public String getName() {
        return "SUV" + this.abbreviation;
    }

    @Override
    public String getUnit() {
        return this.unit.abbreviation;
    }

    public String toString() {
        StringBuilder stringBuilder = new StringBuilder();
        stringBuilder.append("<html>SUV<sub>");
        stringBuilder.append(this.abbreviation);
        stringBuilder.append("</sub></html>");
        return stringBuilder.toString();
    }

    /* synthetic */ StandardizedUptakeValueMethod(String string, int n, String string2, Unit unit, StandardizedUptakeValueMethod standardizedUptakeValueMethod) {
        this(string2, unit);
    }

    private static enum Unit {
        CM2_PER_ML("cm\u00b2/ml"),
        G_PER_ML("g/ml");

        private final String abbreviation;

        private Unit(String string2) {
            this.abbreviation = string2;
        }

        public String toString() {
            return this.abbreviation;
        }
    }
}

