/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.valuemapping.ISUVStudyData;
import com.agfa.pacs.data.shared.valuemapping.IStandardizedUptakeValueMethod;
import com.agfa.pacs.data.shared.valuemapping.PatientSex;
import com.agfa.pacs.data.shared.valuemapping.SUVData;
import org.dcm4che3.data.Attributes;

public class SUVStudyData
implements ISUVStudyData {
    private IStandardizedUptakeValueMethod method;
    private PatientSex patientSex;
    private Double patientWeight;
    private Double patientHeight;

    public SUVStudyData(Attributes attributes, IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) {
        this.method = iStandardizedUptakeValueMethod;
        this.patientSex = PatientSex.getByCode(attributes.getString(0x100040));
        this.patientWeight = SUVData.getDouble(attributes, 0x101030);
        this.patientHeight = SUVData.getDouble(attributes, 0x101020);
        if (this.patientHeight != null) {
            this.patientHeight = this.patientHeight * 100.0;
        }
    }

    @Override
    public boolean needsData() {
        return !this.method.isValidGender(this) || !this.method.isValidWeight(this) || !this.method.isValidHeight(this);
    }

    @Override
    public IStandardizedUptakeValueMethod getMethod() {
        return this.method;
    }

    @Override
    public void setMethod(IStandardizedUptakeValueMethod iStandardizedUptakeValueMethod) throws IllegalArgumentException {
        if (iStandardizedUptakeValueMethod == null) {
            throw new IllegalArgumentException("Null values are not allowed.");
        }
        this.method = iStandardizedUptakeValueMethod;
    }

    @Override
    public PatientSex getPatientSex() {
        return this.patientSex;
    }

    @Override
    public void setPatientSex(PatientSex patientSex) {
        this.patientSex = patientSex;
    }

    @Override
    public Double getPatientWeight() {
        return this.patientWeight;
    }

    @Override
    public void setPatientWeight(Double d) {
        this.patientWeight = d;
    }

    @Override
    public Double getPatientHeight() {
        return this.patientHeight;
    }

    @Override
    public void setPatientHeight(Double d) {
        this.patientHeight = d;
    }
}

