/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.valuemapping.SUVData;
import com.agfa.pacs.tools.DoubleEquals;
import java.util.Arrays;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public enum DecayCorrectionMethod {
    START{

        @Override
        Double getAcquisitionDelay(Attributes attributes, SUVData sUVData) {
            Date date;
            Date date2 = sUVData.getInjectionTime();
            if (date2 == null) {
                return null;
            }
            Date date3 = sUVData.getBaseDateTimeOverride();
            if (date3 == null && (date = attributes.getDate(2251945843097650L)) != null) {
                Double d = sUVData.getIsotope().getHalfLife();
                double d2 = attributes.getDouble(5509888, -1.0);
                int n = (int)Float.parseFloat(attributes.getString(1577538, "0"));
                if (DoubleEquals.equals((double)d2, (double)0.0)) {
                    date3 = date;
                } else if (d != null && d2 > 0.0 && n > 0) {
                    double d3 = Math.log(2.0) / d;
                    double d4 = d3 * ((double)n / 1000.0);
                    double d5 = 1.0 / d3 * Math.log(d4 / (1.0 - Math.exp(-d4)));
                    date3 = new Date(Math.round((double)date.getTime() - d2 + d5 * 1000.0));
                }
            }
            return SUVData.calculateAcquisitionDelay(date3, date2);
        }
    }
    ,
    ADMIN{

        @Override
        Double getAcquisitionDelay(Attributes attributes, SUVData sUVData) {
            return 0.0;
        }
    }
    ,
    UNSUPPORTED{

        @Override
        Double getAcquisitionDelay(Attributes attributes, SUVData sUVData) {
            return null;
        }
    };


    private DecayCorrectionMethod() {
    }

    public static boolean isSupported(Attributes attributes) {
        return DecayCorrectionMethod.create(attributes) != UNSUPPORTED;
    }

    static DecayCorrectionMethod create(Attributes attributes) {
        List<String> list;
        String[] stringArray = attributes.getStrings(2621521);
        if (stringArray != null && (list = Arrays.asList(stringArray)).contains("ATTN") && list.contains("DECY")) {
            try {
                return DecayCorrectionMethod.valueOf(attributes.getString(5509378));
            }
            catch (Exception exception) {}
        }
        return UNSUPPORTED;
    }

    abstract Double getAcquisitionDelay(Attributes var1, SUVData var2);

    /* synthetic */ DecayCorrectionMethod(String string, int n, DecayCorrectionMethod decayCorrectionMethod) {
        this();
    }
}

