/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.valuemapping;

import com.agfa.pacs.data.shared.valuemapping.IValueMapping;
import java.text.DecimalFormat;

public abstract class AbstractValueMapping
implements IValueMapping {
    private static ThreadLocal<DecimalFormat> defaultOutputFormat = new LocalNumberFormat("#");
    private static ThreadLocal<DecimalFormat> smallValueOutputFormat = new LocalNumberFormat("#.##");
    private static ThreadLocal<DecimalFormat> tinyValueOutputFormat = new LocalNumberFormat("0.###");

    @Override
    public Integer getFirstValueMapped() {
        return null;
    }

    @Override
    public Integer getLastValueMapped() {
        return null;
    }

    @Override
    public String formatValue(double d) {
        if (Double.isNaN(d)) {
            return "NA";
        }
        DecimalFormat decimalFormat = -1.0 < d && d < 1.0 ? tinyValueOutputFormat.get() : (-10.0 < d && d < 10.0 ? smallValueOutputFormat.get() : defaultOutputFormat.get());
        return decimalFormat.format(d);
    }

    private static class LocalNumberFormat
    extends ThreadLocal<DecimalFormat> {
        private final String pattern;

        public LocalNumberFormat(String string) {
            this.pattern = string;
        }

        @Override
        protected DecimalFormat initialValue() {
            return new DecimalFormat(this.pattern);
        }
    }
}

