/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.util;

import com.agfa.pacs.data.shared.util.IDicomObjectCoercer;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.eclipse.core.runtime.CoreException;
import org.eclipse.core.runtime.IConfigurationElement;
import org.eclipse.core.runtime.IExtension;
import org.eclipse.core.runtime.IExtensionPoint;
import org.eclipse.core.runtime.Platform;

public class LWDataCorrection {
    private static final ALogger log = ALogger.getLogger(LWDataCorrection.class);
    private static List<IDicomObjectCoercer> coercers = LWDataCorrection.initCoercers();

    public static void correctHeader(Attributes attributes) {
        List<IDicomObjectCoercer> list = coercers;
        int n = list.size();
        int n2 = 0;
        while (n2 < n) {
            list.get(n2).coerce(attributes);
            ++n2;
        }
    }

    private static List<IDicomObjectCoercer> initCoercers() {
        IExtensionPoint iExtensionPoint = Platform.getExtensionRegistry().getExtensionPoint("com.agfa.pacs.data.shared.DicomObjectCoercer");
        IExtension[] iExtensionArray = iExtensionPoint.getExtensions();
        if (iExtensionArray == null) {
            return Collections.emptyList();
        }
        ArrayList<IDicomObjectCoercer> arrayList = new ArrayList<IDicomObjectCoercer>(iExtensionArray.length);
        IExtension[] iExtensionArray2 = iExtensionArray;
        int n = iExtensionArray.length;
        int n2 = 0;
        while (n2 < n) {
            IExtension iExtension = iExtensionArray2[n2];
            IConfigurationElement[] iConfigurationElementArray = iExtension.getConfigurationElements();
            if (iConfigurationElementArray != null) {
                IConfigurationElement[] iConfigurationElementArray2 = iConfigurationElementArray;
                int n3 = iConfigurationElementArray.length;
                int n4 = 0;
                while (n4 < n3) {
                    IConfigurationElement iConfigurationElement = iConfigurationElementArray2[n4];
                    String string = iConfigurationElement.getAttribute("class");
                    try {
                        arrayList.add((IDicomObjectCoercer)iConfigurationElement.createExecutableExtension("class"));
                        log.debug("initialized coercer: " + string);
                    }
                    catch (CoreException coreException) {
                        log.error("failed to initialize coercer: " + string, (Throwable)coreException);
                    }
                    ++n4;
                }
            }
            ++n2;
        }
        return arrayList;
    }
}

