/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.primitives;

import com.agfa.pacs.data.shared.primitives.HashFunctions;
import com.agfa.pacs.data.shared.primitives.IntHashingStrategy;
import com.agfa.pacs.data.shared.primitives.IntProcedure;
import com.agfa.pacs.data.shared.primitives.PrimitiveHash;

abstract class IntHash
extends PrimitiveHash
implements IntHashingStrategy {
    protected transient int[] _set;
    protected IntHashingStrategy _hashingStrategy;

    public IntHash() {
        this._hashingStrategy = this;
    }

    public IntHash(int n) {
        super(n);
        this._hashingStrategy = this;
    }

    public IntHash(int n, float f) {
        super(n, f);
        this._hashingStrategy = this;
    }

    public IntHash(IntHashingStrategy intHashingStrategy) {
        this._hashingStrategy = intHashingStrategy;
    }

    public IntHash(int n, IntHashingStrategy intHashingStrategy) {
        super(n);
        this._hashingStrategy = intHashingStrategy;
    }

    public IntHash(int n, float f, IntHashingStrategy intHashingStrategy) {
        super(n, f);
        this._hashingStrategy = intHashingStrategy;
    }

    @Override
    public Object clone() {
        IntHash intHash = (IntHash)super.clone();
        intHash._set = (int[])this._set.clone();
        return intHash;
    }

    @Override
    protected int setUp(int n) {
        int n2 = super.setUp(n);
        this._set = new int[n2];
        return n2;
    }

    public boolean contains(int n) {
        return this.index(n) >= 0;
    }

    @Override
    protected void removeAt(int n) {
        this._set[n] = 0;
        super.removeAt(n);
    }

    public boolean forEach(IntProcedure intProcedure) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n = nArray.length;
        while (n-- > 0) {
            if (byArray[n] != 1 || intProcedure.execute(nArray[n])) continue;
            return false;
        }
        return true;
    }

    protected int index(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = this._hashingStrategy.computeHashCode(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        if (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
            int n5 = 1 + n3 % (n2 - 2);
            do {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            } while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n));
        }
        return byArray[n4] == 0 ? -1 : n4;
    }

    protected int insertionIndex(int n) {
        byte[] byArray = this._states;
        int[] nArray = this._set;
        int n2 = byArray.length;
        int n3 = this._hashingStrategy.computeHashCode(n) & Integer.MAX_VALUE;
        int n4 = n3 % n2;
        if (byArray[n4] == 0) {
            return n4;
        }
        if (byArray[n4] == 1 && nArray[n4] == n) {
            return -n4 - 1;
        }
        int n5 = 1 + n3 % (n2 - 2);
        if (byArray[n4] != 2) {
            do {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            } while (byArray[n4] == 1 && nArray[n4] != n);
        }
        if (byArray[n4] == 2) {
            int n6 = n4;
            while (byArray[n4] != 0 && (byArray[n4] == 2 || nArray[n4] != n)) {
                if ((n4 -= n5) >= 0) continue;
                n4 += n2;
            }
            return byArray[n4] == 1 ? -n4 - 1 : n6;
        }
        return byArray[n4] == 1 ? -n4 - 1 : n4;
    }

    @Override
    public final int computeHashCode(int n) {
        return HashFunctions.hash(n);
    }
}

