/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel.encoder;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.data.shared.pixel.PixelDataConfiguration;
import com.agfa.pacs.data.shared.pixel.PixelDataException;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoder;
import com.agfa.pacs.data.shared.pixel.encoder.IPixelDataEncoderProvider;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import java.util.Set;

public abstract class PixelDataEncoderFactory {
    private static PixelDataEncoderFactory implementation;
    protected PixelDataConfiguration config = PixelDataConfiguration.instance;

    public static synchronized PixelDataEncoderFactory getInstance() {
        if (implementation == null) {
            PixelDataEncoderFactory.initialize();
        }
        return implementation;
    }

    public Set<String> getSupportedTransferSyntaxUIDs() {
        return Collections.unmodifiableSet(implementation.getSupportedTransferSyntaxUIDsInt());
    }

    public String[] getSupportedTransferSyntaxUIDArray() {
        return implementation.getSupportedTransferSyntaxUIDsInt().toArray(new String[0]);
    }

    public Set<String> filterTransferSyntaxUIDs(String[] stringArray) {
        return this.filterTransferSyntaxUIDs(stringArray, null);
    }

    public Set<String> filterTransferSyntaxUIDs(String[] stringArray, String string) {
        HashSet<String> hashSet = new HashSet<String>();
        Set<String> set = implementation.getSupportedTransferSyntaxUIDsInt();
        if (stringArray != null) {
            String[] stringArray2 = stringArray;
            int n = stringArray.length;
            int n2 = 0;
            while (n2 < n) {
                String string2 = stringArray2[n2];
                if (set.contains(string2)) {
                    hashSet.add(string2);
                } else if (string2.equals(string)) {
                    hashSet.add(string2);
                }
                ++n2;
            }
        }
        return hashSet;
    }

    public IPixelDataEncoder createPixelDataEncoder(String string) throws PixelDataException {
        IPixelDataEncoderProvider iPixelDataEncoderProvider = this.getProvider(string);
        if (iPixelDataEncoderProvider == null) {
            throw new PixelDataException("no encoder for " + string);
        }
        return iPixelDataEncoderProvider.createPixelDataEncoder(string);
    }

    private IPixelDataEncoderProvider getProvider(String string) {
        List<IPixelDataEncoderProvider> list = implementation.getIPixelDataEncoderFactoryInt(string);
        if (list == null) {
            return null;
        }
        if (list.size() == 0) {
            return null;
        }
        String string2 = this.config.getEncoderType(string);
        if (string2 == null) {
            return list.get(0);
        }
        for (IPixelDataEncoderProvider iPixelDataEncoderProvider : list) {
            if (!string2.equals(iPixelDataEncoderProvider.getType())) continue;
            return iPixelDataEncoderProvider;
        }
        return list.get(0);
    }

    protected abstract Set<String> getSupportedTransferSyntaxUIDsInt();

    protected abstract List<IPixelDataEncoderProvider> getIPixelDataEncoderFactoryInt(String var1);

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory((String)PixelDataEncoderFactory.class.getName()));
            implementation = (PixelDataEncoderFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + PixelDataEncoderFactory.class.getName(), reflectiveOperationException);
        }
    }
}

