/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;

public class PixelDataReader {
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private final IPixelDataInfo pixelDataInfo;

    public PixelDataReader(IPixelDataInfo iPixelDataInfo) {
        this.pixelDataInfo = iPixelDataInfo;
    }

    public synchronized Object getData() {
        if (this.pixelDataInfo.getCacheID() != null) {
            if (this.pixelDataInfo.getDataClass() == ByteArrayContainer.class) {
                return cache.referencePersistentObject(this.pixelDataInfo.getCacheID(), ByteArrayContainer.class);
            }
            if (this.pixelDataInfo.getDataClass() == byte[].class) {
                return new ByteArrayContainer(cache.referencePersistentBytes(this.pixelDataInfo.getCacheID()));
            }
            if (this.pixelDataInfo.getDataClass() == short[].class) {
                throw new IllegalStateException();
            }
            if (this.pixelDataInfo.getDataClass() == int[].class) {
                throw new IllegalStateException();
            }
            return null;
        }
        Object object = this.pixelDataInfo.getData();
        if (object instanceof byte[]) {
            return new ByteArrayContainer((byte[])object);
        }
        return object;
    }

    public synchronized void releaseData() {
        if (this.pixelDataInfo.getCacheID() != null) {
            cache.releaseReference(this.pixelDataInfo.getCacheID());
        }
    }
}

