/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.instanceinfo.IInstanceInfo;
import com.agfa.pacs.data.shared.pixel.IPixelAccessor;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import org.dcm4che3.data.Attributes;

public class PixelDataFramePixelDataInfo
implements IPixelDataInfo {
    private final IPixelDataFrame<?> pixelDataFrame;
    private final Attributes description;

    public PixelDataFramePixelDataInfo(IPixelDataFrame<?> iPixelDataFrame, Attributes attributes) {
        this.pixelDataFrame = iPixelDataFrame;
        this.description = attributes;
    }

    @Override
    public CacheID getCacheID() {
        return this.pixelDataFrame.getEncodedDataCacheID();
    }

    @Override
    public Object getData() {
        IPixelAccessor<?> iPixelAccessor = this.pixelDataFrame.getPixelAccessor();
        try {
            Object obj = iPixelAccessor.getData();
            if (obj instanceof byte[]) {
                Object object = ((byte[])obj).clone();
                return object;
            }
            if (obj instanceof short[]) {
                Object object = ((short[])obj).clone();
                return object;
            }
            if (obj instanceof int[]) {
                Object object = ((int[])obj).clone();
                return object;
            }
            return null;
        }
        finally {
            iPixelAccessor.release();
        }
    }

    @Override
    public Class<?> getDataClass() {
        return ByteArrayContainer.class;
    }

    @Override
    public Attributes getDescription() {
        return this.description;
    }

    public IInstanceInfo getInstanceInfo() {
        return null;
    }

    @Override
    public String getTransferSyntaxUID() {
        return this.pixelDataFrame.getEncodedDataTransferSyntaxUID();
    }

    public IPixelDataFrame<?> getPixelDataFrame() {
        return this.pixelDataFrame;
    }

    @Override
    public boolean isLossless() {
        String string = this.pixelDataFrame.getEncodedDataTransferSyntaxUID();
        if (string != null) {
            return !UIDConfiguration.getInstance().getLossyTransferSyntaxUIDs().contains(string);
        }
        return true;
    }
}

