/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.data.shared.dicom.DicomEnum;

public enum PhotometricInterpretation implements DicomEnum
{
    InverseMonochrome("MONOCHROME1", false),
    Monochrome("MONOCHROME2", false),
    RGBColor("RGB", true),
    IndexedColor("PALETTE COLOR", true),
    Color("COLOR", true),
    YBRFull("YBR_FULL", true),
    YBRFull422("YBR_FULL_422", true),
    YBRPartial422("YBR_PARTIAL_422", true),
    YBRPartial420("YBR_PARTIAL_420", true),
    YBRIrreversibleColorTransforamtion("YBR_ICT", true),
    YBRReversibleColorTransforamtion("YBR_RCT", true);

    private final String dicomId;
    private boolean color;

    private PhotometricInterpretation(String string2, boolean bl) {
        this.dicomId = string2;
        this.color = bl;
    }

    @Override
    public String dicom() {
        return this.dicomId;
    }

    public boolean isColor() {
        return this.color;
    }

    public static PhotometricInterpretation get(String string) {
        PhotometricInterpretation[] photometricInterpretationArray = PhotometricInterpretation.values();
        int n = 0;
        while (n < photometricInterpretationArray.length) {
            if (photometricInterpretationArray[n].dicom().equals(string)) {
                return photometricInterpretationArray[n];
            }
            ++n;
        }
        return Monochrome;
    }
}

