/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.data.shared.dicom.UIDConfiguration;
import com.agfa.pacs.data.shared.pixel.IImagePixel;
import com.agfa.pacs.data.shared.pixel.PhotometricInterpretation;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class DatasetImagePixel
implements IImagePixel {
    private static final ALogger log = ALogger.getLogger(DatasetImagePixel.class);
    protected int bitsAllocated;
    protected int bitsStored;
    protected int columns;
    protected int highBit;
    protected PhotometricInterpretation photometricInterpretation;
    protected int pixelRepresentation;
    protected int planarConfiguration;
    protected int rows;
    protected int samplesPerPixel;
    protected boolean lossy;

    public DatasetImagePixel(Attributes attributes) {
        this.bitsStored = attributes.getInt(2621697, 0);
        this.highBit = attributes.getInt(2621698, 0);
        this.bitsAllocated = attributes.getInt(2621696, 0);
        this.columns = attributes.getInt(2621457, 0);
        this.photometricInterpretation = PhotometricInterpretation.get(attributes.getString(2621444));
        this.pixelRepresentation = attributes.getInt(2621699, 0);
        this.planarConfiguration = attributes.getInt(2621446, 0);
        this.rows = attributes.getInt(2621456, 0);
        this.samplesPerPixel = attributes.getInt(0x280002, 1);
        if (this.bitsStored == 0 && this.highBit > 0) {
            this.bitsStored = this.highBit + 1;
            log.warn("DatasetImagePixel incomplete: setting BitsStored from HighBit");
        }
        if (this.bitsStored > 0 && this.highBit == 0) {
            this.highBit = this.bitsStored - 1;
            log.warn("DatasetImagePixel incomplete: setting HighBit from BitsStored");
        }
        if (this.bitsAllocated == 0 && this.bitsStored > 0) {
            this.bitsAllocated = this.bitsStored > 8 ? 16 : 8;
            log.warn("DatasetImagePixel incomplete: setting BitsAllocated from BitsStored");
        }
        this.lossy = UIDConfiguration.getInstance().getLossyTransferSyntaxUIDs().contains(attributes.getString(131088));
        if (this.highBit != this.bitsStored - 1) {
            this.highBit = this.bitsStored - 1;
            log.warn("Value for \"high bit\" and \"bits stored\" are equal. Set highBit = bitsStored-1.");
        }
    }

    @Override
    public boolean isLossy() {
        return this.lossy;
    }

    @Override
    public int getBitsAllocated() {
        return this.bitsAllocated;
    }

    @Override
    public int getBitsStored() {
        return this.bitsStored;
    }

    @Override
    public int getColumns() {
        return this.columns;
    }

    @Override
    public int getHighBit() {
        return this.highBit;
    }

    @Override
    public PhotometricInterpretation getPhotometricInterpretation() {
        return this.photometricInterpretation;
    }

    public void setPhotometricInterpretation(PhotometricInterpretation photometricInterpretation) {
        this.photometricInterpretation = photometricInterpretation;
    }

    @Override
    public int getPixelRepresentation() {
        return this.pixelRepresentation;
    }

    @Override
    public int getPlanarConfiguration() {
        return this.planarConfiguration;
    }

    @Override
    public int getRows() {
        return this.rows;
    }

    @Override
    public int getSamplesPerPixel() {
        return this.samplesPerPixel;
    }

    @Override
    public String getPixelDataProviderURL() {
        return null;
    }

    @Override
    public boolean isColor() {
        return this.samplesPerPixel == 3;
    }

    @Override
    public int getOriginalBitsStored() {
        return this.bitsStored;
    }

    @Override
    public int getOriginalHighBit() {
        return this.highBit;
    }

    @Override
    public boolean isSigned() {
        return this.pixelRepresentation == 1;
    }

    @Override
    public String getGroupID() {
        return null;
    }
}

