/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.pixel;

import com.agfa.pacs.cache.ByteArrayContainer;
import com.agfa.pacs.cache.CacheID;
import com.agfa.pacs.cache.DataCacheProviderFactory;
import com.agfa.pacs.cache.IDataCacheProvider;
import com.agfa.pacs.data.shared.pixel.IPixelDataInfo;
import com.agfa.pacs.data.shared.pixel.PixelDataInfoUtilities;
import org.dcm4che3.data.Attributes;

public class CachedPixelDataInfo
implements IPixelDataInfo {
    private static final IDataCacheProvider cache = DataCacheProviderFactory.getCache();
    private String transferSyntaxUID;
    private CacheID cacheID;
    private Attributes description;
    private boolean asContainer = true;

    public static CachedPixelDataInfo createPDI(String string, byte[] byArray, Attributes attributes) {
        CacheID cacheID = cache.createID();
        cache.addPersistentBytes(byArray, cacheID);
        return new CachedPixelDataInfo(string, cacheID, attributes, false);
    }

    public static CachedPixelDataInfo createPDIFromContainer(String string, byte[] byArray, Attributes attributes) {
        CacheID cacheID = cache.createID();
        ByteArrayContainer byteArrayContainer = new ByteArrayContainer(byArray);
        cache.addPersistentObject((Object)byteArrayContainer, cacheID);
        return new CachedPixelDataInfo(string, cacheID, attributes, true);
    }

    public CachedPixelDataInfo(String string, CacheID cacheID, Attributes attributes, boolean bl) {
        this.transferSyntaxUID = string;
        if (string == null) {
            this.transferSyntaxUID = "1.2.840.10008.1.2";
        }
        this.cacheID = cacheID;
        this.asContainer = bl;
        this.description = attributes;
    }

    public CachedPixelDataInfo(String string, CacheID cacheID, Attributes attributes) {
        this(string, cacheID, attributes, true);
    }

    @Override
    public CacheID getCacheID() {
        return this.cacheID;
    }

    @Override
    public Object getData() {
        return null;
    }

    @Override
    public Class<?> getDataClass() {
        if (this.asContainer) {
            return ByteArrayContainer.class;
        }
        return byte[].class;
    }

    @Override
    public Attributes getDescription() {
        return this.description;
    }

    @Override
    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    @Override
    public boolean isLossless() {
        return PixelDataInfoUtilities.isLossless(this);
    }

    public boolean isDataInCacheMemory() {
        return true;
    }
}

