/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.overlay;

public class BitmapOverlayShrink {
    private int rows;
    private int columns;
    private int[] origin;

    public BitmapOverlayShrink(int n, int n2, int[] nArray) {
        this.rows = n;
        this.columns = n2;
        this.origin = (int[])nArray.clone();
    }

    public byte[] tryToShrink(byte[] byArray) {
        if (byArray.length <= 1) {
            return byArray;
        }
        byte[] byArray2 = this.swapBytes(byArray);
        double d = this.getPositionOfFirstBit(byArray2);
        double d2 = this.getPositionOfLastBit(byArray2);
        int n = (int)Math.floor(d / (double)this.columns);
        if (n == -1) {
            return byArray;
        }
        int n2 = (int)Math.floor(d2 / (double)this.columns);
        int n3 = this.getPositionOfFirstXBit(byArray2);
        int n4 = this.getPositionOfLastXBit(byArray2);
        int n5 = n2 - n + 1;
        int n6 = n4 - n3 + 1;
        byte[] byArray3 = this.extractBytes(byArray2, n * this.columns + n3, n2 * this.columns + n4, n5, n6);
        this.columns = n6;
        this.rows = n5;
        this.origin[0] = this.origin[0] + n;
        this.origin[1] = this.origin[1] + n3;
        return this.swapBytes(byArray3);
    }

    private byte[] extractBytes(byte[] byArray, int n, int n2, int n3, int n4) {
        int n5;
        int n6;
        int n7;
        int n8 = n >> 3;
        int n9 = n % 8;
        int n10 = 8 - n9;
        byte[] byArray2 = new byte[n3 * n4 + 7 >> 3];
        byte[][] byArray3 = new byte[n3][n4 + 7 >> 3];
        int n11 = n;
        int n12 = 0;
        while (n12 < n3) {
            n7 = 0;
            while (n7 < byArray3[n12].length) {
                if (n8 + n7 + 1 < byArray.length) {
                    byte by = (byte)(byArray[n8 + n7] << n9);
                    n6 = (byte)((byArray[n8 + n7 + 1] & 0xFF) >>> n10);
                    byArray3[n12][n7] = (byte)(by | n6);
                } else {
                    byArray3[n12][n7] = (byte)(byArray[n8 + n7] << n9);
                }
                ++n7;
            }
            n9 = (n11 += this.columns) % 8;
            n10 = 8 - n9;
            n8 = n11 >> 3;
            ++n12;
        }
        n12 = 0;
        n7 = n12 % 8;
        byte[][] byArrayArray = new byte[n3][];
        n6 = 0;
        while (n6 < byArray3.length) {
            byArrayArray[n6] = new byte[n4 + 7 + n7 >> 3];
            n5 = 0;
            while (n5 < byArrayArray[n6].length) {
                byArrayArray[n6][n5] = n6 == 0 ? byArray3[n6][n5] : (n5 == 0 ? (byte)((byArray3[n6][n5] & 0xFF) >>> n7) : (n5 < byArray3[n6].length ? (byte)((byArray3[n6][n5] & 0xFF) >>> n7 | byArray3[n6][n5 - 1] << 8 - n7) : (byte)(byArray3[n6][n5 - 1] << 8 - n7)));
                ++n5;
            }
            n7 = (n12 += n4) % 8;
            ++n6;
        }
        n8 = 0;
        n12 = 0;
        n7 = n12 % 8;
        n6 = 0;
        while (n6 < byArrayArray.length) {
            n5 = 0;
            while (n5 < byArrayArray[n6].length) {
                if (n6 != 0 && n5 == 0 && n7 != 0) {
                    ++n5;
                }
                if (n5 < byArrayArray[n6].length) {
                    byArray2[n8++] = n5 == byArrayArray[n6].length - 1 && n6 != byArrayArray.length - 1 && (n7 + n4) % 8 != 0 ? (byte)(byArrayArray[n6][n5] | byArrayArray[n6 + 1][0]) : byArrayArray[n6][n5];
                }
                ++n5;
            }
            n7 = (n12 += n4) % 8;
            ++n6;
        }
        return byArray2;
    }

    public byte[] getPaddedLine(byte[] byArray, int n, int n2, int n3) {
        byte[] byArray2 = new byte[n2 + 7 >> 3];
        int n4 = n * n2 % 8;
        int n5 = n * n2 >> 3;
        int n6 = n5 + (n2 + 7 >> 3);
        int n7 = 0;
        int n8 = n5;
        while (n8 < n6) {
            byArray2[n7++] = n8 + 1 > n6 || n8 + 1 == byArray.length ? (byte)((byArray[n8] & 0xFF) >> n4) : (byte)((byArray[n8] & 0xFF) >> n4 | byArray[n8 + 1] << 8 - n4);
            ++n8;
        }
        return byArray2;
    }

    private int getPositionOfFirstBit(byte[] byArray, int n, int n2) {
        int n3 = n;
        int n4 = n >> 3;
        int n5 = n2 - 1 >> 3;
        int n6 = n % 8;
        while (n4 <= n5) {
            int n7 = byArray[n4++];
            if (n6 != 0) {
                if ((n7 = n7 << n6 & 0xFF) == 0) {
                    n3 += 8 - n6;
                    n6 = 0;
                    continue;
                }
                n6 = 0;
            }
            if (n7 == 0) {
                if ((n3 += 8) < n2) continue;
                return -1;
            }
            while ((n7 & 0x80) != 128) {
                ++n3;
                n7 <<= 1;
            }
            return n3 >= n2 ? -1 : n3;
        }
        return -1;
    }

    private int getPositionOfFirstBit(byte[] byArray) {
        return this.getPositionOfFirstBit(byArray, 0, this.rows * this.columns);
    }

    private int getPositionOfFirstXBit(byte[] byArray) {
        int n = 0;
        int n2 = Integer.MAX_VALUE;
        int n3 = 0;
        int n4 = 0;
        int n5 = 0;
        while (n5 < this.rows) {
            n3 = this.getPositionOfFirstBit(byArray, n4, n4 + this.columns);
            n = n3 - n3 / this.columns * this.columns;
            n4 += this.columns;
            if (n >= 0 && n2 > n) {
                n2 = n;
            }
            ++n5;
        }
        return n2;
    }

    private int getPositionOfLastXBit(byte[] byArray) {
        int n = 0;
        int n2 = Integer.MIN_VALUE;
        int n3 = 0;
        int n4 = this.rows * this.columns;
        int n5 = this.rows - 1;
        while (n5 >= 0) {
            n3 = this.getPositionOfLastBit(byArray, n4 - this.columns, n4);
            n = n3 - n3 / this.columns * this.columns;
            n4 -= this.columns;
            if (n2 < n) {
                n2 = n;
            }
            --n5;
        }
        return n2;
    }

    private int getPositionOfLastBit(byte[] byArray, int n, int n2) {
        int n3 = n2 - 1;
        int n4 = n2 - 1 >> 3;
        int n5 = n >> 3;
        int n6 = (8 - n2 % 8) % 8;
        while (n4 >= n5) {
            int n7 = byArray[n4--];
            if (n6 != 0) {
                if ((n7 >>>= n6) == 0) {
                    n3 -= 8 - n6;
                    n6 = 0;
                    continue;
                }
                n6 = 0;
            }
            if (n7 == 0) {
                if ((n3 -= 8) >= 0) continue;
                return -1;
            }
            while ((n7 & 1) != 1) {
                --n3;
                n7 >>= 1;
            }
            return n3 < n ? -1 : n3;
        }
        return -1;
    }

    private int getPositionOfLastBit(byte[] byArray) {
        return this.getPositionOfLastBit(byArray, 0, this.rows * this.columns);
    }

    public int getRows() {
        return this.rows;
    }

    public int getColumns() {
        return this.columns;
    }

    public int[] getOriginCopy() {
        return (int[])this.origin.clone();
    }

    private byte[] swapBytes(byte[] byArray) {
        byte[] byArray2 = new byte[byArray.length];
        int n = 0;
        while (n < byArray.length) {
            byte by = byArray[n];
            int n2 = (by & 0x80) >>> 7 | by << 7 | (by & 2) << 5 | (by & 0x40) >>> 5 | (by & 4) << 3 | (by & 0x20) >>> 3 | (by & 8) << 1 | (by & 0x10) >>> 1;
            byArray2[n] = (byte)n2;
            ++n;
        }
        return byArray2;
    }
}

