/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.node.config;

import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.node.DataInfoNodeProviderFactory;
import com.agfa.pacs.data.shared.node.IDataInfoNode;
import com.agfa.pacs.data.shared.node.IDataInfoNodeProvider;
import com.agfa.pacs.data.shared.properties.PropertiesUser;
import com.agfa.pacs.data.shared.properties.PropertiesUtilities;
import com.agfa.pacs.logging.ALogger;
import java.util.Properties;

public class DataInfoNodeConfigurationUtilities {
    private static final ALogger LOGGER = ALogger.getLogger(DataInfoNodeConfigurationUtilities.class);

    public static IDataInfoNode getDataInfoNode(IConfigurationProvider iConfigurationProvider) throws Exception {
        IDataInfoNodeProvider iDataInfoNodeProvider;
        DataInfoNodeProviderFactory dataInfoNodeProviderFactory = DataInfoNodeProviderFactory.getInstance();
        String string = iConfigurationProvider.getString("type");
        String string2 = iConfigurationProvider.getString("name");
        Long l = null;
        try {
            l = iConfigurationProvider.getLong("orderId");
        }
        catch (Exception exception) {
            LOGGER.warn("order id not available/parsable for type " + string + " and name " + string2);
        }
        boolean bl = true;
        if (iConfigurationProvider.exists("searchable")) {
            bl = iConfigurationProvider.getBoolean("searchable");
        }
        boolean bl2 = true;
        if (iConfigurationProvider.exists("servicesSearchable")) {
            bl2 = iConfigurationProvider.getBoolean("servicesSearchable");
        }
        if ((iDataInfoNodeProvider = dataInfoNodeProviderFactory.getDataNodeProvider(string)) != null) {
            PropertiesUser propertiesUser = iDataInfoNodeProvider.getPropertiesUser();
            if (propertiesUser.requiresProperties() && !propertiesUser.onlyOptionalProperties() && iConfigurationProvider.exists("properties")) {
                Properties properties = PropertiesUtilities.readPropertiesFromConfig(iConfigurationProvider.getNode("properties"), propertiesUser, null);
                IDataInfoNode iDataInfoNode = iDataInfoNodeProvider.createDataNode(string2, properties);
                if (l != null) {
                    iDataInfoNode.setOrderId(l.intValue());
                }
                iDataInfoNode.setUserSearchable(bl);
                iDataInfoNode.setServicesSearchable(bl2);
                return iDataInfoNode;
            }
            IDataInfoNode iDataInfoNode = iDataInfoNodeProvider.createDataNode(string2, new Properties());
            if (l != null) {
                iDataInfoNode.setOrderId(l.intValue());
            }
            return iDataInfoNode;
        }
        return null;
    }

    public static IDataInfoNode getDataInfoNodeForService(String string) throws Exception {
        DataInfoNodeProviderFactory dataInfoNodeProviderFactory = DataInfoNodeProviderFactory.getInstance();
        String string2 = "AGFADICOMWADO";
        String string3 = string.substring(0, string.indexOf(64));
        String string4 = string.substring(string.indexOf(64) + 1, string.indexOf(58));
        String string5 = string.substring(string.indexOf(58) + 1);
        IDataInfoNodeProvider iDataInfoNodeProvider = dataInfoNodeProviderFactory.getDataNodeProvider(string2);
        if (iDataInfoNodeProvider != null) {
            Properties properties = new Properties();
            properties.put("calledAET", string3);
            properties.put("host", string4);
            properties.put("port", string5);
            properties.put("wadoURI", "http://" + string4 + ":8080/wado");
            IDataInfoNode iDataInfoNode = iDataInfoNodeProvider.createDataNode(string3, properties);
            iDataInfoNode.setOrderId(-1);
            iDataInfoNode.setUserSearchable(true);
            iDataInfoNode.setServicesSearchable(true);
            return iDataInfoNode;
        }
        return null;
    }
}

