/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.lw.impl;

import com.agfa.pacs.data.shared.lw.IDataInfo;
import com.agfa.pacs.data.shared.lw.IDataInfoSource;
import com.agfa.pacs.data.shared.lw.TagLevel;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public abstract class AbstractDataInfo
implements IDataInfo {
    private static final ALogger log = ALogger.getLogger(AbstractDataInfo.class);
    private static Map<Class<?>, Constructor<AbstractDataInfo>> constructors = new HashMap();
    protected IDataInfo treeParent;
    protected String key;
    protected IDataInfoSource source;
    protected Attributes dataset;

    public AbstractDataInfo(IDataInfo iDataInfo, String string) {
        this.key = string;
        this.setTreeParent(iDataInfo);
        if (iDataInfo != null) {
            this.source = iDataInfo.getSource();
        }
        this.dataset = new Attributes();
    }

    public AbstractDataInfo(Attributes attributes, IDataInfo iDataInfo, String string) {
        this.key = string;
        this.setTreeParent(iDataInfo);
        if (iDataInfo != null) {
            this.source = iDataInfo.getSource();
        }
        this.dataset = attributes;
    }

    @Override
    public IDataInfo getTreeParent() {
        return this.treeParent;
    }

    @Override
    public void setTreeParent(IDataInfo iDataInfo) {
        this.treeParent = iDataInfo;
    }

    @Override
    public IDataInfoSource getSource() {
        return this.source;
    }

    @Override
    public void setSource(IDataInfoSource iDataInfoSource) {
        this.source = iDataInfoSource;
    }

    @Override
    public String getKey() {
        return this.key;
    }

    @Override
    public IDataInfo deepCopy(boolean bl) {
        try {
            AbstractDataInfo abstractDataInfo = (AbstractDataInfo)this.copy(bl);
            return abstractDataInfo;
        }
        catch (Exception exception) {
            log.error("DataInfo deep copy error", (Throwable)exception);
            return null;
        }
    }

    public IDataInfo deepCopy() {
        return this.deepCopy(true);
    }

    @Override
    public IDataInfo copy(boolean bl) {
        try {
            Constructor<AbstractDataInfo> constructor = constructors.get(this.getClass());
            if (constructor == null) {
                try {
                    constructor = this.getClass().getConstructor(IDataInfo.class, String.class);
                    constructors.put(this.getClass(), constructor);
                }
                catch (NoSuchMethodException noSuchMethodException) {
                    return this;
                }
            }
            AbstractDataInfo abstractDataInfo = constructor.newInstance(this.treeParent, this.key);
            this.copyInternal(abstractDataInfo, bl);
            return abstractDataInfo;
        }
        catch (Exception exception) {
            log.error("DataInfo copy error", (Throwable)exception);
            return null;
        }
    }

    protected void copyInternal(AbstractDataInfo abstractDataInfo, boolean bl) {
        abstractDataInfo.dataset = bl ? new Attributes(this.dataset) : this.dataset;
        abstractDataInfo.source = this.source;
        abstractDataInfo.key = this.key;
    }

    public boolean equals(Object object) {
        return this == object;
    }

    @Override
    public boolean containsValue(int n) {
        return this.dataset.containsValue(n);
    }

    public Attributes getAttributes() {
        return this.dataset;
    }

    public List<Attributes> getItems(int n, String string) {
        Sequence sequence = this.dataset.getSequence(string, n);
        if (sequence == null) {
            return Collections.emptyList();
        }
        ArrayList<Attributes> arrayList = new ArrayList<Attributes>(sequence.size());
        int n2 = 0;
        while (n2 < sequence.size()) {
            arrayList.add((Attributes)sequence.get(n2));
            ++n2;
        }
        return arrayList;
    }

    public Attributes createItem(int n, String string) {
        Sequence sequence = this.dataset.getSequence(string, n);
        if (sequence == null) {
            sequence = this.dataset.newSequence(string, n, 1);
        }
        Attributes attributes = new Attributes();
        sequence.add(attributes);
        return attributes;
    }

    public int hashCode() {
        return super.hashCode();
    }

    @Override
    public Attributes getDicomObjectMerged() {
        Attributes attributes = new Attributes();
        attributes.addAll(this.dataset);
        if (this.treeParent != null && this.treeParent.getHierarchyLevel() != null) {
            attributes.addAll(this.treeParent.getDicomObjectMerged());
        }
        return attributes;
    }

    public void readFrom(Attributes attributes) {
        attributes.addAll(this.dataset);
    }

    public void writeTo(Attributes attributes) {
        this.dataset.addAll(attributes);
    }

    public String toString() {
        if (this.hasChildren()) {
            if (this.childrenAvailable()) {
                StringBuilder stringBuilder = new StringBuilder();
                for (IDataInfo iDataInfo : this.children()) {
                    stringBuilder.append('\n').append(iDataInfo.toString());
                }
                if (stringBuilder.toString().length() < 1) {
                    return "";
                }
                return stringBuilder.toString().substring(1);
            }
            return "<children not yet retrieved>";
        }
        return "<no children>";
    }

    @Override
    public boolean equalsKey(IDataInfo iDataInfo) {
        if (iDataInfo != null) {
            return iDataInfo.getKey().equals(this.getKey());
        }
        return false;
    }

    @Override
    public <U extends IDataInfo> U cloneInto(Class<U> clazz) {
        throw new UnsupportedOperationException();
    }

    @Override
    public TagLevel getLevelOfStorage(int n) {
        throw new UnsupportedOperationException();
    }

    @Override
    public String getTransactionUID() {
        throw new UnsupportedOperationException();
    }

    @Override
    public void shareDicomObjectContainer() {
        throw new UnsupportedOperationException();
    }

    public void setAttributes(Attributes attributes) {
        this.dataset = attributes;
    }

    @Override
    public Date getDate(int n) {
        return this.getAttributes().getDate(n);
    }

    @Override
    public int getInt(int n) {
        return this.getAttributes().getInt(n, 0);
    }

    @Override
    public String getString(int n) {
        return this.getAttributes().getString(n);
    }
}

