/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.keyobject;

import com.agfa.pacs.config.ConfigurationProviderFactory;
import com.agfa.pacs.config.IConfigurationList;
import com.agfa.pacs.config.IConfigurationProvider;
import com.agfa.pacs.data.shared.Messages;
import com.agfa.pacs.keyobject.IKeyObjectTitleProvider;
import com.agfa.pacs.keyobject.KeyObjectTitle;
import com.agfa.pacs.keyobject.KeyObjectTitleComparator;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.TreeSet;
import org.apache.commons.lang3.Pair;

public class KeyObjectTitleProvider
implements IKeyObjectTitleProvider {
    private static final IConfigurationProvider config = ConfigurationProviderFactory.getConfig();
    private static final Map<Pair<String, String>, KeyObjectTitle> codeToTitle;
    private static final Set<KeyObjectTitle> sortedTitles;

    static {
        HashMap<Pair, KeyObjectTitle> hashMap = new HashMap<Pair, KeyObjectTitle>();
        TreeSet<KeyObjectTitle> treeSet = new TreeSet<KeyObjectTitle>((Comparator<KeyObjectTitle>)new KeyObjectTitleComparator());
        IConfigurationList iConfigurationList = config.getList("keyImage.titles");
        Map map = iConfigurationList.getChildrenItems();
        for (Map.Entry entry : map.entrySet()) {
            IConfigurationProvider iConfigurationProvider = (IConfigurationProvider)entry.getValue();
            int n = Integer.parseInt((String)entry.getKey());
            String string = iConfigurationProvider.getString("schemeDesignator");
            String string2 = iConfigurationProvider.getString("code");
            String string3 = iConfigurationProvider.getString("meaning");
            String string4 = iConfigurationProvider.getString("externalStringID");
            String string5 = Messages.getString(string4);
            boolean bl = iConfigurationProvider.getBoolean("rejected");
            KeyObjectTitle keyObjectTitle = new KeyObjectTitle(n, string, string2, string3, string5, bl);
            IConfigurationList iConfigurationList2 = iConfigurationProvider.getList("subtitles");
            Map map2 = iConfigurationList2.getChildrenItems();
            for (Map.Entry entry2 : map2.entrySet()) {
                IConfigurationProvider iConfigurationProvider2 = (IConfigurationProvider)entry2.getValue();
                int n2 = Integer.parseInt((String)entry2.getKey());
                String string6 = iConfigurationProvider2.getString("code");
                String string7 = iConfigurationProvider2.getString("meaning");
                String string8 = iConfigurationProvider2.getString("externalStringID");
                String string9 = Messages.getString(string8);
                KeyObjectTitle keyObjectTitle2 = new KeyObjectTitle(n2, string, string6, string7, string9, false);
                keyObjectTitle.addSubTitle(keyObjectTitle2);
            }
            hashMap.put(new Pair((Object)string, (Object)string2), keyObjectTitle);
            treeSet.add(keyObjectTitle);
        }
        codeToTitle = Collections.unmodifiableMap(hashMap);
        sortedTitles = Collections.unmodifiableSet(treeSet);
    }

    public Set<KeyObjectTitle> getTitles() {
        return sortedTitles;
    }

    public KeyObjectTitle getTitleForCode(String string, String string2) {
        return codeToTitle.get(new Pair((Object)string, (Object)string2));
    }

    public KeyObjectTitle getTitleForCode(String string) {
        return this.getTitleForCode("DCM", string);
    }
}

