/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.instanceinfo.impl;

import com.agfa.pacs.data.shared.instanceinfo.AbstractInstanceInfo;
import com.agfa.pacs.logging.ALogger;
import java.net.URI;
import java.net.URISyntaxException;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.VR;

public class URIInstanceInfo
extends AbstractInstanceInfo {
    private static final ALogger logger = ALogger.getLogger(URIInstanceInfo.class);
    public static final String TYPE = "URI";
    private URI uri;
    private String transferSyntaxUID;

    public URIInstanceInfo() {
    }

    public URIInstanceInfo(URI uRI) {
        if (uRI == null) {
            throw new IllegalArgumentException("url == null");
        }
        this.uri = uRI;
    }

    public URIInstanceInfo(URI uRI, String string) {
        this(uRI);
        this.transferSyntaxUID = string;
    }

    @Override
    public String getType() {
        return TYPE;
    }

    public URI getURI() {
        return this.uri;
    }

    public String getTransferSyntaxUID() {
        return this.transferSyntaxUID;
    }

    public String toString() {
        String string = super.toString();
        String string2 = null;
        if (this.uri != null) {
            string2 = this.uri.toString();
        }
        return String.valueOf(string) + " " + string2;
    }

    @Override
    public void readFrom(Attributes attributes) {
        try {
            this.uri = new URI(attributes.getString("AGFA-AG_InstanceInfo", 4390944));
        }
        catch (URISyntaxException uRISyntaxException) {
            logger.warn("Encountered invalid URI", (Throwable)uRISyntaxException);
        }
    }

    @Override
    public String getURIString() {
        return this.getURI().toString();
    }

    @Override
    public void writeTo(Attributes attributes) {
        attributes.setString("AGFA-AG_InstanceInfo", 4390944, VR.ST, this.uri.toASCIIString());
    }
}

