/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.icon.impl;

import com.agfa.pacs.data.shared.icon.DefaultIconFactory;
import com.agfa.pacs.data.shared.icon.IIconCache;
import com.agfa.pacs.data.shared.icon.IIconInfo;
import java.util.LinkedHashMap;
import java.util.Map;

public class DefaultIconCache
implements IIconCache {
    private static final int MAX_LOAD_FACTOR = 3000;
    private static final DefaultIconCache instance = new DefaultIconCache();
    private Map<String, IIconInfo> icons = new ConstrainedHashMap<String, IIconInfo>(3000);

    public static DefaultIconCache getInstance() {
        return instance;
    }

    private DefaultIconCache() {
    }

    @Override
    public IIconInfo getDefaultIcon(String string) {
        return DefaultIconFactory.getInstance().getDefaultIcon(string);
    }

    @Override
    public void putIcon(String string, IIconInfo iIconInfo) {
        this.icons.put(string, iIconInfo);
    }

    @Override
    public boolean hasIcon(String string) {
        return this.icons.containsKey(string);
    }

    @Override
    public IIconInfo getIcon(String string) {
        return this.icons.get(string);
    }

    private static class ConstrainedHashMap<K, V>
    extends LinkedHashMap<K, V> {
        private final int maxEntries;

        public ConstrainedHashMap(int n) {
            this.maxEntries = n;
        }

        @Override
        protected boolean removeEldestEntry(Map.Entry<K, V> entry) {
            return this.size() > this.maxEntries;
        }
    }
}

