/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.HttpURLConnection;

public class HttpConnectionErrorException
extends IOException {
    private static final long serialVersionUID = -8336127028269426073L;
    public static final String COMMENT_GENERIC_SLOW = "WaitForGenericSlowImageRetrieval";
    public static final String COMMENT_AGGREGATED_HEADER_CREATION = "WaitForAggregatedHeaderCreation";
    public static final String COMMENT_CMOVE_RESPONSE = "WaitForCMoveResponse";
    public static final String COMMENT_HOLO = "WaitForPACSArchivedStudy";
    private final int responseCode;
    private final String responseComment;

    public HttpConnectionErrorException(int n, String string, String string2) {
        super(string2);
        this.responseCode = n;
        this.responseComment = string;
    }

    public int getResponseCode() {
        return this.responseCode;
    }

    public String getResponseComment() {
        return this.responseComment;
    }

    public static StringBuilder compileResponseMessage(HttpURLConnection httpURLConnection) throws IOException {
        StringBuilder stringBuilder = new StringBuilder(httpURLConnection.getResponseMessage());
        InputStream inputStream = httpURLConnection.getErrorStream();
        if (inputStream != null) {
            Throwable throwable = null;
            Object var4_5 = null;
            try (BufferedReader bufferedReader = new BufferedReader(new InputStreamReader(inputStream));){
                while (bufferedReader.ready()) {
                    stringBuilder.append('\n');
                    stringBuilder.append(bufferedReader.readLine());
                }
            }
            catch (Throwable throwable2) {
                if (throwable == null) {
                    throwable = throwable2;
                } else if (throwable != throwable2) {
                    throwable.addSuppressed(throwable2);
                }
                throw throwable;
            }
        }
        return stringBuilder;
    }

    public static String parseResponseMessagesComment(String string) {
        if (string == null) {
            return null;
        }
        if (string.contains(COMMENT_HOLO)) {
            return COMMENT_HOLO;
        }
        if (string.contains(COMMENT_CMOVE_RESPONSE)) {
            return COMMENT_CMOVE_RESPONSE;
        }
        if (string.contains(COMMENT_AGGREGATED_HEADER_CREATION)) {
            return COMMENT_AGGREGATED_HEADER_CREATION;
        }
        if (string.contains(COMMENT_GENERIC_SLOW)) {
            return COMMENT_GENERIC_SLOW;
        }
        return null;
    }

    public boolean isUnexpected() {
        return !this.responseComment.equals(COMMENT_HOLO) && !this.responseComment.equals(COMMENT_CMOVE_RESPONSE);
    }
}

