/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.hw;

import com.agfa.pacs.data.shared.hw.DicomDataRequester;
import com.agfa.pacs.data.shared.hw.IDicomDataRequest;
import com.agfa.pacs.data.shared.hw.IDicomRetriever;
import com.agfa.pacs.data.shared.hw.IRequestManager;
import com.agfa.pacs.data.shared.hw.IRequestVisitor;
import com.agfa.pacs.data.shared.hw.SameInstanceRequestVisitor;
import com.agfa.pacs.data.shared.hw.SameStudyRequestVisitor;
import com.agfa.pacs.data.shared.lw.IObjectInfo;
import com.agfa.pacs.data.shared.lw.IStudyInfo;
import com.agfa.pacs.logging.ALogger;
import java.util.List;

public abstract class AbstractDicomRetriever
implements IDicomRetriever {
    private static IRequestManager requestManager;
    private static final ALogger log;

    static {
        log = ALogger.getLogger(AbstractDicomRetriever.class);
    }

    @Override
    public void process(IDicomDataRequest iDicomDataRequest) {
        try {
            this.processImpl(iDicomDataRequest);
        }
        catch (Exception exception) {
            log.error("Error in loading", (Throwable)exception);
            iDicomDataRequest.dicomDataError(iDicomDataRequest.getLoadableInfo().getUID(), exception.getLocalizedMessage(), exception);
        }
    }

    @Override
    public boolean supportConcurrentLoadingOnFrameLevel() {
        return false;
    }

    protected abstract void processImpl(IDicomDataRequest var1);

    protected IRequestManager getRequestManager() {
        if (requestManager == null) {
            requestManager = DicomDataRequester.getInstance();
        }
        return requestManager;
    }

    protected void visitRequests(IRequestVisitor iRequestVisitor, IDicomDataRequest iDicomDataRequest) {
        RequestVisitor requestVisitor = new RequestVisitor(iRequestVisitor, iDicomDataRequest);
        this.getRequestManager().visitRequests(requestVisitor);
    }

    protected List<IDicomDataRequest> getRequestsOfSameInstance(IDicomDataRequest iDicomDataRequest, int n) {
        IObjectInfo iObjectInfo = iDicomDataRequest.getObjectInfo();
        SameInstanceRequestVisitor sameInstanceRequestVisitor = new SameInstanceRequestVisitor(iObjectInfo, n);
        sameInstanceRequestVisitor.requests().add(iDicomDataRequest);
        this.visitRequests(sameInstanceRequestVisitor, iDicomDataRequest);
        return sameInstanceRequestVisitor.requests();
    }

    protected List<IDicomDataRequest> getRequestsOfSameStudy(IDicomDataRequest iDicomDataRequest) {
        IObjectInfo iObjectInfo = iDicomDataRequest.getObjectInfo();
        IStudyInfo iStudyInfo = (IStudyInfo)iObjectInfo.getTreeParent().getTreeParent();
        SameStudyRequestVisitor sameStudyRequestVisitor = new SameStudyRequestVisitor(iStudyInfo);
        sameStudyRequestVisitor.requests().add(iDicomDataRequest);
        this.visitRequests(sameStudyRequestVisitor, iDicomDataRequest);
        return sameStudyRequestVisitor.requests();
    }

    private static class RequestVisitor
    implements IRequestVisitor {
        private final IRequestVisitor requestVisitor;
        private final IDicomDataRequest initialRequest;

        public RequestVisitor(IRequestVisitor iRequestVisitor, IDicomDataRequest iDicomDataRequest) {
            this.requestVisitor = iRequestVisitor;
            this.initialRequest = iDicomDataRequest;
        }

        public boolean offerRequest(IDicomDataRequest iDicomDataRequest) {
            if (this.initialRequest.getDataProviderIdentifier().equals(iDicomDataRequest.getDataProviderIdentifier())) {
                return this.requestVisitor.offerRequest(iDicomDataRequest);
            }
            return false;
        }

        public boolean wantsMore() {
            return this.requestVisitor.wantsMore();
        }
    }
}

