/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.export;

import com.agfa.pacs.background.BackgroundTaskEngineFactory;
import com.agfa.pacs.background.IBackgroundProgress;
import com.agfa.pacs.background.IBackgroundTask;
import com.agfa.pacs.background.IBackgroundTaskEngine;
import com.agfa.pacs.data.shared.export.IProcessingElement;
import com.agfa.pacs.data.shared.export.ProcessingElementFactory;
import com.agfa.pacs.data.shared.export.ProcessingElementWrapper;
import com.agfa.pacs.data.shared.export.ProcessingException;
import com.agfa.pacs.data.shared.export.ProcessingWarning;
import com.agfa.pacs.logging.ALogger;
import java.beans.PropertyChangeEvent;
import java.beans.PropertyChangeListener;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Properties;
import java.util.Set;
import java.util.concurrent.ArrayBlockingQueue;
import java.util.concurrent.BlockingQueue;
import java.util.concurrent.LinkedBlockingQueue;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicInteger;
import org.dcm4che3.util.UIDUtils;
import org.eclipse.core.runtime.CoreException;

public class BackgroundProcessingTask {
    private static final ALogger log = ALogger.getLogger(BackgroundProcessingTask.class);
    public static final String RUNNING_STATE = "RUNNING_STATE";
    private static final String ANY_TYPE = "ANY";
    private int numberOfConcurrentTasks = 1;
    private IProcessingElement[] processors;
    private String inputType = null;
    private boolean isCorrectlyInitated = false;
    private SharedTaskInfo lastTask = null;
    private String info;

    public BackgroundProcessingTask(String[] stringArray) throws IllegalArgumentException {
        this.init(stringArray);
    }

    public BackgroundProcessingTask(String string) throws IllegalArgumentException {
        String[] stringArray = string.split("->");
        this.init(stringArray);
    }

    public String getInfo() {
        return this.info;
    }

    public void setInfo(String string) {
        this.info = string;
    }

    private void init(String[] stringArray) {
        String string;
        int n = 0;
        while (n < stringArray.length) {
            stringArray[n] = stringArray[n].trim().toUpperCase(Locale.ENGLISH);
            ++n;
        }
        Set<String> set = ProcessingElementFactory.getProcessingTypes();
        String[] stringArray2 = stringArray;
        int n2 = stringArray.length;
        int n3 = 0;
        while (n3 < n2) {
            string = stringArray2[n3];
            if (!set.contains(string)) {
                throw new IllegalArgumentException("Pipeline element:" + string + " is not known");
            }
            ++n3;
        }
        string = "";
        this.processors = new IProcessingElement[stringArray.length];
        n3 = 0;
        while (n3 < stringArray.length) {
            ProcessingElementWrapper processingElementWrapper = ProcessingElementFactory.getProcessingElementWrapper(stringArray[n3]);
            if (n3 == 0) {
                this.inputType = processingElementWrapper.inputType;
            } else if (!(processingElementWrapper.inputType == null || processingElementWrapper.inputType.equalsIgnoreCase(ANY_TYPE) || string.equalsIgnoreCase(ANY_TYPE) || string.equalsIgnoreCase(processingElementWrapper.inputType))) {
                throw new IllegalArgumentException("Incorrect piping on element:" + processingElementWrapper.name);
            }
            try {
                this.processors[n3] = processingElementWrapper.createProcessor();
            }
            catch (CoreException coreException) {
                log.error("Could not initiate Processor:" + processingElementWrapper.name, (Throwable)coreException);
                throw new IllegalArgumentException(coreException.getLocalizedMessage());
            }
            string = processingElementWrapper.outputType;
            ++n3;
        }
        this.isCorrectlyInitated = true;
    }

    protected final boolean isCorrectlyInitated() {
        return this.isCorrectlyInitated;
    }

    public IProcessingElement[] getProcessingElements() {
        return this.processors;
    }

    public synchronized IBackgroundTask createTask(List<? extends Object> list, Properties properties, PropertyChangeListener propertyChangeListener) throws IllegalArgumentException {
        return this.createTasks(list, properties, propertyChangeListener, true)[0];
    }

    public synchronized IBackgroundTask process(List<? extends Object> list, Properties properties, PropertyChangeListener propertyChangeListener) throws IllegalArgumentException {
        ProcessingTask[] processingTaskArray = this.createTasks(list, properties, propertyChangeListener, false);
        IBackgroundTaskEngine iBackgroundTaskEngine = BackgroundTaskEngineFactory.getInstance();
        ProcessingTask[] processingTaskArray2 = processingTaskArray;
        int n = processingTaskArray.length;
        int n2 = 0;
        while (n2 < n) {
            ProcessingTask processingTask = processingTaskArray2[n2];
            iBackgroundTaskEngine.placeBackgroundTask((IBackgroundTask)processingTask);
            ++n2;
        }
        return processingTaskArray[0];
    }

    private synchronized ProcessingTask[] createTasks(List<? extends Object> list, Properties properties, PropertyChangeListener propertyChangeListener, boolean bl) throws IllegalArgumentException {
        Object object;
        if (!this.isCorrectlyInitated) {
            throw new IllegalArgumentException("Not initialised");
        }
        if (!bl) {
            IProcessingElement[] iProcessingElementArray = this.processors;
            int n = this.processors.length;
            int n2 = 0;
            while (n2 < n) {
                object = iProcessingElementArray[n2];
                if (!object.supportsConcurrentProcessing()) {
                    this.numberOfConcurrentTasks = 1;
                    break;
                }
                ++n2;
            }
        } else {
            this.numberOfConcurrentTasks = 1;
        }
        object = null;
        object = list != null ? new ArrayBlockingQueue(list.size() + 10) : new LinkedBlockingQueue(100);
        ProcessingTask[] processingTaskArray = new ProcessingTask[this.numberOfConcurrentTasks];
        SharedTaskInfo sharedTaskInfo = new SharedTaskInfo(properties, (BlockingQueue<Object>)object);
        sharedTaskInfo.setListener(propertyChangeListener);
        sharedTaskInfo.setNumberOfProcessors(this.numberOfConcurrentTasks);
        processingTaskArray[0] = new ProcessingTask(list, sharedTaskInfo, true);
        int n = 1;
        while (n < processingTaskArray.length) {
            processingTaskArray[n] = new ProcessingTask(null, sharedTaskInfo, false);
            ++n;
        }
        this.lastTask = sharedTaskInfo;
        return processingTaskArray;
    }

    public IBackgroundTask process(List<? extends Object> list, Properties properties) throws IllegalArgumentException {
        return this.process(list, properties, null);
    }

    protected final int getNumberOfConcurrentTasks() {
        return this.numberOfConcurrentTasks;
    }

    protected final void setNumberOfConcurrentTasks(int n) {
        this.numberOfConcurrentTasks = n;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public void waitUntilFinished() {
        if (this.lastTask == null) {
            return;
        }
        boolean bl = false;
        if (!this.lastTask.isFinished) {
            Object object = this.lastTask.lock;
            synchronized (object) {
                while (!this.lastTask.isFinished) {
                    try {
                        this.lastTask.lock.wait();
                    }
                    catch (InterruptedException interruptedException) {
                        bl = true;
                    }
                }
            }
        }
        if (bl) {
            log.error("Interupting:" + Thread.currentThread());
            Thread.currentThread().interrupt();
        }
    }

    public boolean isRunning() {
        if (this.lastTask == null) {
            return false;
        }
        return this.lastTask.isFinished;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public List<Object> getFailedInputObjects() {
        if (this.lastTask == null) {
            return Collections.emptyList();
        }
        SharedTaskInfo sharedTaskInfo = this.lastTask;
        synchronized (sharedTaskInfo) {
            List<Object> list = this.lastTask.failedInputObjects;
            if (list == null) {
                list = Collections.emptyList();
            }
            return list;
        }
    }

    private class ProcessingTask
    implements IBackgroundTask {
        private static final long MAX_TIMEOUT = 120L;
        private SharedTaskInfo taskInfo = null;
        private List<? extends Object> objects = null;
        private final String UID;
        private IBackgroundProgress progress = null;
        private final boolean mainTask;

        public ProcessingTask(List<? extends Object> list, SharedTaskInfo sharedTaskInfo, boolean bl) {
            this.objects = list;
            this.taskInfo = sharedTaskInfo;
            this.mainTask = bl;
            this.UID = UIDUtils.createUID();
        }

        /*
         * Enabled aggressive exception aggregation
         */
        public boolean execute() {
            int n = 0;
            boolean bl = false;
            this.notify(BackgroundProcessingTask.RUNNING_STATE, false, true);
            try {
                Object object;
                int n2;
                if (this.mainTask) {
                    Object object2;
                    IProcessingElement[] iProcessingElementArray = BackgroundProcessingTask.this.processors;
                    n2 = iProcessingElementArray.length;
                    int n3 = 0;
                    while (n3 < n2) {
                        object2 = iProcessingElementArray[n3];
                        object2.prepareProcessing(this.taskInfo.properties, this.objects);
                        ++n3;
                    }
                    if (this.objects == null) {
                        n = 1;
                        object2 = BackgroundProcessingTask.this.processors[0].process(null);
                        if (object2.getClass().isArray()) {
                            Object[] objectArray = (Object[])object2;
                            this.taskInfo.setTotalCount(objectArray.length);
                            Object[] objectArray2 = objectArray;
                            int n4 = objectArray.length;
                            int n5 = 0;
                            while (n5 < n4) {
                                Object object3 = objectArray2[n5];
                                this.taskInfo.queue.add(object3);
                                ++n5;
                            }
                        } else {
                            this.taskInfo.setTotalCount(1);
                            this.taskInfo.queue.add(object2);
                        }
                    } else {
                        this.taskInfo.setTotalCount(this.objects.size());
                        this.taskInfo.queue.addAll(this.objects);
                    }
                    int n6 = 0;
                    while (n6 < this.taskInfo.getNumberOfProcessors()) {
                        this.taskInfo.queue.add(new TerminationTag(false));
                        ++n6;
                    }
                }
                while (true) {
                    if ((object = this.taskInfo.queue.poll(120L, TimeUnit.SECONDS)) == null) {
                        return false;
                    }
                    if (object instanceof TerminationTag) {
                        if (!((TerminationTag)object).isCanceled) break;
                        this.notifyFinished();
                        return false;
                    }
                    try {
                        this.process(object, n);
                    }
                    catch (ProcessingWarning processingWarning) {
                        BackgroundProcessingTask.this.setInfo(processingWarning.getLocalizedMessage());
                        bl = true;
                        log.warn("Warning on processing pipeline:", (Throwable)processingWarning);
                        this.taskInfo.addFailedInputObject(object);
                    }
                    this.taskInfo.nextProcessed();
                    this.progress.progress((double)this.taskInfo.getProcessed() / this.taskInfo.getTotalCount(), this.getInfo());
                }
                if (this.mainTask) {
                    IProcessingElement[] iProcessingElementArray = BackgroundProcessingTask.this.processors;
                    n2 = iProcessingElementArray.length;
                    int n7 = 0;
                    while (n7 < n2) {
                        object = iProcessingElementArray[n7];
                        object.finishProcessing();
                        ++n7;
                    }
                    this.notifyFinished();
                }
                return !bl;
            }
            catch (ProcessingException processingException) {
                BackgroundProcessingTask.this.setInfo(processingException.getLocalizedMessage());
                this.progress.progress(1.0, this.getInfo());
                log.error("Error on processing pipeline", (Throwable)processingException);
                this.taskInfo.cancel();
                this.notifyFinished();
            }
            catch (RuntimeException runtimeException) {
                BackgroundProcessingTask.this.setInfo(runtimeException.getLocalizedMessage());
                this.progress.progress(1.0, this.getInfo());
                log.error("Runtime exception on processing pipeline", (Throwable)runtimeException);
                this.taskInfo.cancel();
                this.notifyFinished();
            }
            catch (InterruptedException interruptedException) {
                log.error("Timeout interruption", (Throwable)interruptedException);
                this.taskInfo.cancel();
                this.notifyFinished();
            }
            return false;
        }

        private void notify(String string, Object object, Object object2) {
            if (this.taskInfo.getListener() != null) {
                PropertyChangeEvent propertyChangeEvent = new PropertyChangeEvent(this, string, object, object2);
                this.taskInfo.getListener().propertyChange(propertyChangeEvent);
            }
        }

        private void cleanup() {
            IProcessingElement[] iProcessingElementArray = BackgroundProcessingTask.this.processors;
            int n = iProcessingElementArray.length;
            int n2 = 0;
            while (n2 < n) {
                IProcessingElement iProcessingElement = iProcessingElementArray[n2];
                iProcessingElement.cleanUp();
                ++n2;
            }
        }

        private void process(Object object, int n) throws ProcessingException {
            Object object2 = BackgroundProcessingTask.this.processors[n].process(object);
            if (object2 == null) {
                return;
            }
            if (object2.getClass().isArray()) {
                Object[] objectArray = (Object[])object2;
                if (n + 1 == BackgroundProcessingTask.this.processors.length) {
                    return;
                }
                Object[] objectArray2 = objectArray;
                int n2 = objectArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    Object object3 = objectArray2[n3];
                    this.process(object3, n + 1);
                    ++n3;
                }
            } else {
                if (n + 1 == BackgroundProcessingTask.this.processors.length) {
                    return;
                }
                this.process(object2, n + 1);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        private void notifyFinished() {
            if (this.taskInfo.isFinished) {
                return;
            }
            this.cleanup();
            Object object = this.taskInfo.lock;
            synchronized (object) {
                this.taskInfo.isFinished = true;
                this.taskInfo.lock.notifyAll();
            }
            this.notify(BackgroundProcessingTask.RUNNING_STATE, true, false);
        }

        public String getInfo() {
            return BackgroundProcessingTask.this.info;
        }

        public String getUID() {
            return this.UID;
        }

        public void take(IBackgroundProgress iBackgroundProgress) {
            this.progress = iBackgroundProgress;
        }

        public void terminate() {
            this.taskInfo.cancel();
        }
    }

    private static class SharedTaskInfo {
        public final BlockingQueue<Object> queue;
        private double totalCount = 0.0;
        private AtomicInteger processedCount = new AtomicInteger(0);
        private final Properties properties;
        private PropertyChangeListener listener = null;
        private final Object lock = new Object();
        private volatile boolean isFinished = false;
        private int numberOfProcessors;
        private List<Object> failedInputObjects = null;

        public SharedTaskInfo(Properties properties, BlockingQueue<Object> blockingQueue) {
            this.queue = blockingQueue;
            this.properties = properties;
        }

        public void nextProcessed() {
            this.processedCount.incrementAndGet();
        }

        public final double getTotalCount() {
            return this.totalCount;
        }

        public final void setTotalCount(int n) {
            this.totalCount = n;
        }

        protected final int getNumberOfProcessors() {
            return this.numberOfProcessors;
        }

        protected final void setNumberOfProcessors(int n) {
            this.numberOfProcessors = n;
        }

        public int getProcessed() {
            return this.processedCount.get();
        }

        protected final PropertyChangeListener getListener() {
            return this.listener;
        }

        protected final void setListener(PropertyChangeListener propertyChangeListener) {
            this.listener = propertyChangeListener;
        }

        protected final void cancel() {
            this.queue.clear();
            int n = 0;
            while (n < this.getNumberOfProcessors()) {
                this.queue.add(new TerminationTag(true));
                ++n;
            }
        }

        protected synchronized void addFailedInputObject(Object object) {
            if (this.failedInputObjects == null) {
                this.failedInputObjects = new ArrayList<Object>();
            }
            this.failedInputObjects.add(object);
        }
    }

    private static class TerminationTag {
        public final boolean isCanceled;

        public TerminationTag(boolean bl) {
            this.isCanceled = bl;
        }
    }
}

