/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.DicomDataListenerAdapter;
import com.agfa.pacs.data.shared.data.IDicomDataListener;
import com.agfa.pacs.data.shared.util.Waitable;
import com.agfa.pacs.logging.ALogger;
import org.dcm4che3.data.Attributes;

public class WaitDicomDataListenerAdapter
extends DicomDataListenerAdapter
implements Waitable {
    private static final ALogger log = ALogger.getLogger(WaitDicomDataListenerAdapter.class);
    private volatile boolean finished = false;
    private String errorMessage = null;
    private Throwable errorCause;

    @Override
    public synchronized void dicomDataFinished(String string, IDicomDataListener.Status status, Attributes attributes) {
        this.finished = true;
        this.notifyAll();
    }

    public boolean isFinished() {
        return this.finished;
    }

    @Override
    public synchronized void waitUntilFinished() {
        while (!this.finished) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                log.error("WaitUntil Data Listener", (Throwable)interruptedException);
            }
        }
    }

    @Override
    public void dicomDataError(String string, String string2, Throwable throwable) {
        this.errorMessage = string2;
        this.errorCause = throwable;
        this.finished = true;
        this.notifyAll();
    }

    public boolean hasError() {
        return this.errorMessage != null;
    }

    public String getErrorMessage() {
        return this.errorMessage;
    }

    public Throwable getErrorCause() {
        return this.errorCause;
    }

    @Override
    public synchronized void waitUntilFinished(int n) {
        while (!this.finished) {
            try {
                this.wait(n);
            }
            catch (InterruptedException interruptedException) {
                log.error("WaitUntil Data Listener", (Throwable)interruptedException);
            }
        }
    }

    public void cancel() {
    }
}

