/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.data;

import com.agfa.pacs.data.shared.data.DatasetSource;
import com.agfa.pacs.data.shared.dicom.DicomEnum;
import com.agfa.pacs.logging.ALogger;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.ElementDictionary;
import org.dcm4che3.data.Fragments;
import org.dcm4che3.data.Sequence;
import org.dcm4che3.data.VR;
import org.dcm4che3.util.TagUtils;

public class DatasetAccessor {
    private static final ALogger log = ALogger.getLogger(DatasetAccessor.class);

    protected DatasetAccessor() {
    }

    protected void set(DicomEnum dicomEnum, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(dicomEnum, attributes, n, type)) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), dicomEnum.dicom());
        }
    }

    protected void set(DicomEnum[] dicomEnumArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(dicomEnumArray, attributes, n, type)) {
            String[] stringArray = new String[dicomEnumArray.length];
            int n2 = 0;
            while (n2 < dicomEnumArray.length) {
                stringArray[n2] = dicomEnumArray[n2].dicom();
                ++n2;
            }
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), stringArray);
        }
    }

    protected void set(String string, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(string, attributes, n, type)) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), string);
        }
    }

    protected void set(String[] stringArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(stringArray, attributes, n, type)) {
            attributes.setString(n, ElementDictionary.vrOf((int)n, null), stringArray);
        }
    }

    protected void set(Date date, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(date, attributes, n, type)) {
            attributes.setDate(n, ElementDictionary.vrOf((int)n, null), new Date[]{date});
        }
    }

    protected void set(Date date, Attributes attributes, long l, Type type) {
        if (date == null) {
            int n = (int)(l >>> 32);
            int n2 = (int)l;
            if (type == Type.MandatoryOrEmpty) {
                attributes.setNull(n, ElementDictionary.vrOf((int)n, null));
                attributes.setNull(n2, ElementDictionary.vrOf((int)n2, null));
            }
        }
        attributes.setDate(l, date);
    }

    protected void set(Date[] dateArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(dateArray, attributes, n, type)) {
            attributes.setDate(n, ElementDictionary.vrOf((int)n, null), dateArray);
        }
    }

    protected void set(Integer n, Attributes attributes, int n2, Type type) {
        if (!this.checkForNull(n, attributes, n2, type)) {
            if (ElementDictionary.vrOf((int)n2, null) == VR.IS) {
                attributes.setString(n2, ElementDictionary.vrOf((int)n2, null), n.toString());
            } else {
                attributes.setInt(n2, ElementDictionary.vrOf((int)n2, null), new int[]{n});
            }
        }
    }

    protected void set(int[] nArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(nArray, attributes, n, type)) {
            attributes.setInt(n, ElementDictionary.vrOf((int)n, null), nArray);
        }
    }

    protected void set(int[] nArray, Attributes attributes, int n, String string) {
        if (nArray != null) {
            attributes.setInt(string, n, ElementDictionary.vrOf((int)n, (String)string), nArray);
        }
    }

    protected void set(float[] fArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(fArray, attributes, n, type)) {
            attributes.setFloat(n, ElementDictionary.vrOf((int)n, null), fArray);
        }
    }

    protected void set(Float f, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(f, attributes, n, type)) {
            attributes.setFloat(n, ElementDictionary.vrOf((int)n, null), new float[]{f.floatValue()});
        }
    }

    protected void set(Double d, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(d, attributes, n, type)) {
            attributes.setDouble(n, ElementDictionary.vrOf((int)n, null), new double[]{d});
        }
    }

    protected void set(double[] dArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(dArray, attributes, n, type)) {
            attributes.setDouble(n, ElementDictionary.vrOf((int)n, null), dArray);
        }
    }

    protected void set(DatasetSource datasetSource, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(datasetSource, attributes, n, type, VR.SQ)) {
            Sequence sequence = attributes.newSequence(n, 1);
            sequence.add(datasetSource.toDataset());
        } else if (type != Type.Mandatory && type != Type.MandatoryOrEmpty) {
            attributes.remove(n);
        }
    }

    protected void set(DatasetSource datasetSource, Attributes attributes) {
        if (datasetSource != null) {
            attributes.addAll(datasetSource.toDataset());
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void set(Collection<? extends Object> collection, Attributes attributes, int n, Type type) {
        if (collection != null && collection.isEmpty()) {
            collection = null;
        }
        if (!this.checkForNull(collection, attributes, n, type)) {
            Object object = collection.iterator().next();
            if (object instanceof DicomEnum) {
                String[] stringArray = new String[collection.size()];
                boolean n2 = false;
                for (Object object2 : collection) {
                    void object3;
                    stringArray[object3] = ((DicomEnum)object2).dicom();
                    ++object3;
                }
                attributes.setString(n, ElementDictionary.vrOf((int)n, null), stringArray);
            } else if (object instanceof DatasetSource) {
                Sequence sequence = attributes.newSequence(n, collection.size());
                for (Object object3 : collection) {
                    sequence.add(((DatasetSource)object3).toDataset());
                }
            } else if (object instanceof String) {
                attributes.setString(n, ElementDictionary.vrOf((int)n, null), collection.toArray(new String[0]));
            }
        }
    }

    protected void set(byte[] byArray, Attributes attributes, int n, Type type) {
        if (!this.checkForNull(byArray, attributes, n, type)) {
            attributes.setBytes(n, ElementDictionary.vrOf((int)n, null), byArray);
        }
    }

    protected void set(byte[] byArray, Attributes attributes, int n, String string) {
        if (byArray != null) {
            attributes.setBytes(string, n, ElementDictionary.vrOf((int)n, (String)string), byArray);
        }
    }

    protected void setFragments(List<byte[]> list, Attributes attributes, int n) {
        if (list != null) {
            Fragments fragments = attributes.newFragments(n, null, list.size());
            for (byte[] byArray : list) {
                fragments.add((Object)byArray);
            }
        }
    }

    protected String getString(Attributes attributes, int n, String string) {
        try {
            return attributes.getString(string, n);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected String getString(Attributes attributes, int n) {
        try {
            return attributes.getString(n, null);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected String[] getStrings(Attributes attributes, int n) {
        try {
            return attributes.getStrings(n);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected List<String> getStringsAsList(Attributes attributes, int n) {
        try {
            String[] stringArray = attributes.getStrings(n);
            ArrayList<String> arrayList = new ArrayList<String>();
            if (stringArray != null) {
                String[] stringArray2 = stringArray;
                int n2 = stringArray.length;
                int n3 = 0;
                while (n3 < n2) {
                    String string = stringArray2[n3];
                    arrayList.add(string);
                    ++n3;
                }
            }
            return arrayList;
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected Integer getInteger(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getInt(n, 0);
    }

    protected int[] getIntegers(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getInts(n);
    }

    public static int[] getLUTDescriptor(Attributes attributes) {
        block3: {
            try {
                if (attributes.contains(2633730)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(2633730, exception);
                return null;
            }
        }
        int[] nArray = attributes.getInts(2633730);
        nArray[0] = nArray[0] & 0xFFFF;
        return nArray;
    }

    protected int[] getIntegers(Attributes attributes, int n, String string) {
        block3: {
            try {
                if (attributes.contains(string, n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getInts(string, n);
    }

    protected Integer getInteger(Attributes attributes, int n, String string) {
        block3: {
            try {
                if (attributes.contains(string, n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getInt(string, n, 0);
    }

    protected Date getDate(Attributes attributes, int n) {
        try {
            return attributes.getDate(n);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected Date getDate(Attributes attributes, long l) {
        try {
            return attributes.getDate(l);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet((int)(l >>> 32), exception);
            return null;
        }
    }

    protected Date[] getDates(Attributes attributes, int n) {
        try {
            return attributes.getDates(n);
        }
        catch (Exception exception) {
            DatasetAccessor.exceptionHandlingOnGet(n, exception);
            return null;
        }
    }

    protected Double getDouble(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getDouble(n, 0.0);
    }

    protected double[] getDoubles(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getDoubles(n);
    }

    protected Float getFloat(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return Float.valueOf(attributes.getFloat(n, 0.0f));
    }

    protected float[] getFloats(Attributes attributes, int n) {
        block3: {
            try {
                if (attributes.contains(n)) break block3;
                return null;
            }
            catch (Exception exception) {
                DatasetAccessor.exceptionHandlingOnGet(n, exception);
                return null;
            }
        }
        return attributes.getFloats(n);
    }

    protected boolean match(int[] nArray, int[] nArray2) {
        if (nArray == null && nArray2 == null) {
            return true;
        }
        if (nArray == null != (nArray2 == null)) {
            return false;
        }
        if (nArray.length != nArray2.length) {
            return false;
        }
        int n = 0;
        while (n < nArray.length) {
            if (nArray[n] != nArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean match(double[] dArray, double[] dArray2) {
        if (dArray == null && dArray2 == null) {
            return true;
        }
        if (dArray == null != (dArray2 == null)) {
            return false;
        }
        if (dArray.length != dArray2.length) {
            return false;
        }
        int n = 0;
        while (n < dArray.length) {
            if (dArray[n] != dArray2[n]) {
                return false;
            }
            ++n;
        }
        return true;
    }

    protected boolean match(Number number, Number number2) {
        if (number == null && number2 == null) {
            return true;
        }
        if (number == null != (number2 == null)) {
            return false;
        }
        return number.equals(number2);
    }

    private void warnIsNull(int n) {
        if (log.isDebugEnabled()) {
            log.debug("Mandatory field (" + DatasetAccessor.tagInfo(n) + ") is null !");
        }
    }

    private static String tagInfo(int n) {
        return TagUtils.toString((int)n);
    }

    private boolean checkForNull(Object object, Attributes attributes, int n, Type type, VR vR) {
        if (object == null) {
            if (type == Type.Mandatory) {
                this.warnIsNull(n);
            } else if (type == Type.MandatoryOrEmpty) {
                attributes.setNull(n, vR);
            }
            return true;
        }
        return false;
    }

    private boolean checkForNull(Object object, Attributes attributes, int n, Type type) {
        return this.checkForNull(object, attributes, n, type, ElementDictionary.vrOf((int)n, null));
    }

    private static void exceptionHandlingOnGet(int n, Exception exception) {
        log.warn("Tag " + DatasetAccessor.tagInfo(n) + " decoding problem: " + exception.getClass() + " " + exception.getMessage());
    }

    public static enum Type {
        Mandatory,
        MandatoryOrEmpty,
        Optional,
        ConditionalMandatory,
        ConditionalMandatoryOrEmpty,
        ContinonalOptional;

    }
}

