/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.data.shared.code;

import com.agfa.pacs.data.shared.code.Code;
import com.agfa.pacs.data.shared.code.MammoCode;
import com.agfa.pacs.logging.ALogger;
import java.lang.reflect.Field;
import java.util.ArrayList;
import java.util.List;
import org.dcm4che3.data.Attributes;
import org.dcm4che3.data.Sequence;

public class MammoViewModifier
extends MammoCode {
    private static final ALogger LOGGER = ALogger.getLogger(MammoViewModifier.class);
    private final ViewCodeLocation viewCodeLocation;
    public static final MammoViewModifier[] Cleavage = MammoViewModifier.createViewModifier("R-102D2", "Cleavage", "CV", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier[] AxillaryTail = MammoViewModifier.createViewModifier("R-102D1", "Axillary Tail", "AT", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier[] RolledLateral = MammoViewModifier.createViewModifier("R-102D3", "Rolled Lateral", "RL", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] RolledMedial = MammoViewModifier.createViewModifier("R-102D4", "Rolled Medial", "RM", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] RolledInferior = MammoViewModifier.createViewModifier("R-102CA", "Rolled Inferior", "RI", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] RolledSuperior = MammoViewModifier.createViewModifier("R-102C9", "Rolled Superior", "RS", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] ImplantDisplaced = MammoViewModifier.createViewModifier("R-102D5", "Implant Displaced", "ID", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] Magnification = MammoViewModifier.createViewModifier("R-102D6", "Magnification", "M", ViewCodeLocation.PREFIX);
    public static final MammoViewModifier[] SpotCompression = MammoViewModifier.createViewModifier("R-102D7", "Spot Compression", "S", ViewCodeLocation.PREFIX);
    public static final MammoViewModifier[] Tangential = MammoViewModifier.createViewModifier("R-102C2", "Tangential", "TAN", ViewCodeLocation.REPLACEMENT);
    public static final MammoViewModifier[] NippleInProfile = MammoViewModifier.createViewModifier("R-40AB3", "Nipple in profile", "NP", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] AnteriorCompression = MammoViewModifier.createViewModifier("P2-00161", "Anterior compression", "AC", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] InfraMammaryFold = MammoViewModifier.createViewModifier("R-40ABE", "Infra-mammary fold", "IMF", ViewCodeLocation.SUFFIX);
    public static final MammoViewModifier[] AxillaryTissue = MammoViewModifier.createViewModifier("R-40AB2", "Axillary tissue", "AX", ViewCodeLocation.SUFFIX);
    private static final List<MammoViewModifier> codes = MammoViewModifier.initViewModifiers();

    private MammoViewModifier(String string, String string2, String string3, String string4, ViewCodeLocation viewCodeLocation) {
        super(string, string2, string3, string4);
        this.viewCodeLocation = viewCodeLocation;
    }

    public ViewCodeLocation getViewCodeLocation() {
        return this.viewCodeLocation;
    }

    private static MammoViewModifier[] createViewModifier(String string, String string2, String string3, ViewCodeLocation viewCodeLocation) {
        return new MammoViewModifier[]{new MammoViewModifier("SNM3", string, string2, string3, viewCodeLocation), new MammoViewModifier("SRT", string, string2, string3, viewCodeLocation)};
    }

    private static List<MammoViewModifier> initViewModifiers() {
        Field[] fieldArray;
        ArrayList<MammoViewModifier> arrayList = new ArrayList<MammoViewModifier>();
        Field[] fieldArray2 = fieldArray = MammoViewModifier.class.getDeclaredFields();
        int n = fieldArray.length;
        int n2 = 0;
        while (n2 < n) {
            Field field = fieldArray2[n2];
            if (field.getType() == MammoViewModifier[].class) {
                try {
                    MammoViewModifier[] mammoViewModifierArray;
                    MammoViewModifier[] mammoViewModifierArray2 = mammoViewModifierArray = (MammoViewModifier[])field.get(null);
                    int n3 = mammoViewModifierArray.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        MammoViewModifier mammoViewModifier = mammoViewModifierArray2[n4];
                        arrayList.add(mammoViewModifier);
                        ++n4;
                    }
                }
                catch (Exception exception) {
                    LOGGER.error("Error accessing object " + field.toString(), (Throwable)exception);
                }
            }
            ++n2;
        }
        return arrayList;
    }

    private static List<Code> getViewModifierCodes(Attributes attributes) {
        List<Code> list = null;
        Sequence sequence = attributes.getSequence(5505568);
        if (sequence != null && !sequence.isEmpty()) {
            list = Code.createList((Attributes)sequence.get(0), 5505570);
        }
        if (list == null || list.isEmpty()) {
            list = Code.createList(attributes, 5505570);
        }
        return list;
    }

    public static List<MammoViewModifier> getViewModifiers(Attributes attributes) {
        List<Code> list = MammoViewModifier.getViewModifierCodes(attributes);
        ArrayList<MammoViewModifier> arrayList = new ArrayList<MammoViewModifier>(list.size());
        for (Code code : list) {
            for (MammoViewModifier mammoViewModifier : codes) {
                if (!mammoViewModifier.equals(code)) continue;
                arrayList.add(mammoViewModifier);
            }
        }
        return arrayList;
    }

    public static Iterable<MammoViewModifier> getViewModifiers() {
        return codes;
    }

    @Override
    public boolean equals(Object object) {
        return super.equals(object);
    }

    @Override
    public int hashCode() {
        return super.hashCode();
    }

    public static enum ViewCodeLocation {
        PREFIX,
        SUFFIX,
        REPLACEMENT;

    }
}

