/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentationstate;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.interfaces.ICompositeInformationObject;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationState;
import com.agfa.pacs.listtext.dicomobject.presentation.IFramePresentationStateProvider;
import com.agfa.pacs.listtext.dicomobject.presentationstate.AbstractPresentationStateInfo;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.dcm4che3.data.Attributes;

public class ExternalPresentationStateInfo
extends AbstractPresentationStateInfo {
    private IFramePresentationStateProvider firstProvider = null;
    private final boolean temporaryExternal;
    private final int displaySetID;

    public ExternalPresentationStateInfo(boolean bl, int n) {
        this.temporaryExternal = bl;
        this.displaySetID = n;
    }

    @Override
    public String getDescription() {
        if (this.providers.isEmpty()) {
            return null;
        }
        return this.firstProvider.getDescription();
    }

    @Override
    public void add(IFramePresentationStateProvider iFramePresentationStateProvider) {
        super.add(iFramePresentationStateProvider);
        this.firstProvider = iFramePresentationStateProvider;
    }

    @Override
    public List<ICompositeInformationObject> getDicomInformationObjects() {
        ArrayList<ICompositeInformationObject> arrayList = new ArrayList<ICompositeInformationObject>(this.providers.size());
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            ICompositeInformationObject iCompositeInformationObject = iFramePresentationStateProvider.getDicomInformationObject();
            if (iCompositeInformationObject == null) continue;
            arrayList.add(iCompositeInformationObject);
        }
        return arrayList;
    }

    @Override
    public String getLabel() {
        if (this.firstProvider == null) {
            return null;
        }
        return this.firstProvider.getLabel();
    }

    @Override
    public Date getCreationDateTime() {
        if (this.firstProvider == null) {
            return null;
        }
        return this.firstProvider.getCreationDateTime();
    }

    @Override
    public boolean hasFramePresentationState(String string, int n) {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.hasFramePresentationState(string, n)) continue;
            return true;
        }
        return false;
    }

    @Override
    public IFramePresentationState getFramePresentationState(String string, Attributes attributes, int n, IPixelDataFrame<?> iPixelDataFrame) {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.hasFramePresentationState(string, n)) continue;
            return iFramePresentationStateProvider.getFramePresentationState(string, attributes, n, iPixelDataFrame);
        }
        return null;
    }

    @Override
    public boolean isExternal() {
        return true;
    }

    public int getDisplaySetID() {
        return this.displaySetID;
    }

    @Override
    public boolean isTemporary() {
        return this.temporaryExternal;
    }

    private String maskNull(String string) {
        if (string == null) {
            return "";
        }
        return string;
    }

    public String toString() {
        if (this.temporaryExternal) {
            return this.getDescription();
        }
        if (this.getDescription() == null) {
            return this.maskNull(this.getLabel());
        }
        return this.maskNull(this.getDescription());
    }

    @Override
    public String getFramePresentationStateUID(String string, int n) {
        for (IFramePresentationStateProvider iFramePresentationStateProvider : this.providers) {
            if (!iFramePresentationStateProvider.hasFramePresentationState(string, n)) continue;
            return iFramePresentationStateProvider.getProviderUID();
        }
        return this.firstProvider.getProviderUID();
    }

    @Override
    public Attributes getDataset() {
        return this.firstProvider.getDataset();
    }

    @Override
    public String getUID() {
        return this.firstProvider.getProviderUID();
    }
}

