/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.rendering;

import com.agfa.pacs.listtext.dicomobject.module.ps.PresentationSizeMode;
import com.agfa.pacs.listtext.dicomobject.presentation.rendering.PresentationRenderSettings;
import com.agfa.pacs.listtext.dicomobject.type.AnnotationUnits;
import java.awt.Graphics2D;
import java.awt.geom.AffineTransform;
import java.awt.image.BufferedImage;

public class PresentationRenderContext
implements PresentationRenderSettings {
    private static final double DPI_2_MM = 25.4;
    public static final double DEFAULT_DPI = 72.0;
    private double[] pixelSpacing = null;
    private BufferedImage image = null;
    private Graphics2D graphics;
    private int graphicsWidth;
    private int graphicsHeight;
    private int width;
    private int height;
    private boolean applyShutter = true;
    private boolean applyOverlays = true;
    private boolean applyGraphicAnnotations = true;
    private boolean applyMapping = true;
    private boolean displayedAreaMapping = true;
    private boolean applyIndicators = true;
    private boolean resetTranslationZoom = true;
    private boolean lutsOnly = false;
    private int biType;
    private String device = "screen";
    private boolean previewMode = false;
    private PresentationSizeMode sizeMode = PresentationSizeMode.ScaleToFit;

    public String getDevice() {
        return this.device;
    }

    public void setDevice(String string) {
        this.device = string;
        if (string.equalsIgnoreCase("print")) {
            this.resetTranslationZoom = false;
        }
    }

    public boolean shouldResetTranslationZoom() {
        return this.resetTranslationZoom;
    }

    public boolean isPreviewMode() {
        return this.previewMode;
    }

    public void setPreviewMode(boolean bl) {
        this.previewMode = bl;
    }

    private PresentationRenderContext() {
    }

    public PresentationRenderContext(BufferedImage bufferedImage) {
        this((Graphics2D)bufferedImage.getGraphics(), bufferedImage.getWidth(), bufferedImage.getHeight(), bufferedImage.getType());
        this.image = bufferedImage;
    }

    public PresentationSizeMode getSizeMode() {
        return this.sizeMode;
    }

    public void setSizeMode(PresentationSizeMode presentationSizeMode) {
        this.sizeMode = presentationSizeMode;
    }

    public PresentationRenderContext(Graphics2D graphics2D, int n, int n2, int n3) {
        this();
        this.width = n;
        this.height = n2;
        this.graphicsWidth = n;
        this.graphicsHeight = n2;
        this.biType = n3;
        this.graphics = graphics2D;
    }

    public double getDPI() {
        if (this.pixelSpacing == null) {
            return 72.0;
        }
        return 25.4 / this.pixelSpacing[0];
    }

    public void setPixelSpacingDPI(double d, double d2) {
        this.pixelSpacing = new double[]{25.4 / d, 25.4 / d2};
    }

    public double[] getPixelSpacing() {
        return this.pixelSpacing;
    }

    public BufferedImage getImage() {
        return this.image;
    }

    public Graphics2D getGraphics() {
        return this.graphics;
    }

    public int getHeight() {
        return this.height;
    }

    public void setHeight(int n) {
        this.height = n;
    }

    public int getWidth() {
        return this.width;
    }

    public void setWidth(int n) {
        this.width = n;
    }

    public boolean applyIndicators() {
        return this.applyIndicators;
    }

    public void setApplyIndicators(boolean bl) {
        this.applyIndicators = bl;
    }

    public AffineTransform getTransform(AnnotationUnits annotationUnits) {
        if (AnnotationUnits.Pixel.equals((Object)annotationUnits)) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-1.0, -1.0);
            return affineTransform;
        }
        if (AnnotationUnits.Display.equals((Object)annotationUnits)) {
            AffineTransform affineTransform = new AffineTransform();
            affineTransform.translate(-1.0, -1.0);
            affineTransform.scale(this.width, this.height);
            return affineTransform;
        }
        return null;
    }

    public int getGraphicsHeight() {
        return this.graphicsHeight;
    }

    public int getGraphicsWidth() {
        return this.graphicsWidth;
    }

    @Override
    public boolean applyGraphicAnnotations() {
        return this.applyGraphicAnnotations;
    }

    public void setApplyGraphicAnnotations(boolean bl) {
        this.applyGraphicAnnotations = bl;
    }

    @Override
    public boolean applyMapping() {
        return this.applyMapping;
    }

    public void setApplyMapping(boolean bl, boolean bl2) {
        this.applyMapping = bl;
        this.displayedAreaMapping = bl2;
    }

    @Override
    public boolean applyOverlays() {
        return this.applyOverlays;
    }

    public void setApplyOverlays(boolean bl) {
        this.applyOverlays = bl;
    }

    @Override
    public boolean applyShutter() {
        return this.applyShutter;
    }

    public void setApplyShutter(boolean bl) {
        this.applyShutter = bl;
    }

    @Override
    public boolean isDisplayedAreaMapping() {
        return this.displayedAreaMapping;
    }

    @Override
    public boolean isLUTsOnly() {
        return this.lutsOnly;
    }

    public void setLUTsOnly(boolean bl) {
        this.lutsOnly = bl;
    }

    public void setSettings(PresentationRenderSettings presentationRenderSettings) {
        this.setApplyShutter(presentationRenderSettings.applyShutter());
        this.setApplyOverlays(presentationRenderSettings.applyOverlays());
        this.setApplyGraphicAnnotations(presentationRenderSettings.applyGraphicAnnotations());
        this.setApplyMapping(presentationRenderSettings.applyMapping(), presentationRenderSettings.isDisplayedAreaMapping());
        this.setLUTsOnly(presentationRenderSettings.isLUTsOnly());
    }

    public int getBufferedImageType() {
        return this.biType;
    }
}

