/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.EmptyOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.StringOverlayDataWriter;
import com.agfa.pacs.logging.ALogger;

public class StringOverlayDataFactory
implements IOverlayDataFactory {
    private static final ALogger log = ALogger.getLogger(StringOverlayDataFactory.class);

    @Override
    public IOverlayData createOverlayData(byte[] byArray, int n, int n2, int n3) {
        int n4 = n * n2 + 7 >> 3;
        int n5 = n4 * n3;
        byte[] byArray2 = new byte[n4];
        try {
            System.arraycopy(byArray, n5, byArray2, 0, n4);
        }
        catch (Exception exception) {
            log.error("Could not copy overlay data");
            return new StringOverlayData(new byte[0], 0, 0);
        }
        return new StringOverlayData(byArray2, n, n2);
    }

    @Override
    public IOverlayData createOverlayData(IPixelDataFrame iPixelDataFrame, int n) {
        try {
            int n2;
            int n3;
            byte by;
            byte by2;
            Object[] objectArray;
            int n4;
            Object object = iPixelDataFrame.getOriginalData();
            int n5 = iPixelDataFrame.getWidth();
            int n6 = iPixelDataFrame.getHeight();
            byte[] byArray = null;
            if (object instanceof byte[]) {
                n4 = 0;
                objectArray = (byte[])object;
                byArray = new byte[n5 * n6 + 7 >> 3];
                by2 = 0;
                by = 0;
                n3 = 0;
                while (n3 < byArray.length) {
                    n2 = 7;
                    while (n2 >= 0 && n4 + n2 < objectArray.length) {
                        by2 = objectArray[n4 + n2];
                        by = (byte)(by << 1 | by2 >> n & 1);
                        --n2;
                    }
                    n4 += 8;
                    byArray[n3] = by;
                    ++n3;
                }
                byArray[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << (8 - n5 * n6 % 8) % 8);
            }
            if (object instanceof short[]) {
                n4 = 0;
                objectArray = (short[])object;
                byArray = new byte[n5 * n6 + 7 >> 3];
                by2 = 0;
                by = 0;
                n3 = 0;
                while (n3 < byArray.length) {
                    n2 = 7;
                    while (n2 >= 0 && n4 + n2 < objectArray.length) {
                        by2 = objectArray[n4 + n2];
                        by = (byte)(by << 1 | by2 >> n & 1);
                        --n2;
                    }
                    n4 += 8;
                    byArray[n3] = by;
                    ++n3;
                }
                byArray[byArray.length - 1] = (byte)(byArray[byArray.length - 1] << (8 - n5 * n6 % 8) % 8);
            }
            iPixelDataFrame.releaseOriginalData(object);
            return new StringOverlayData(byArray, n5, n6);
        }
        catch (Exception exception) {
            log.error("Overlay error", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }

    @Override
    public IOverlayDataWriter createOverlayDataWriter() {
        return new StringOverlayDataWriter();
    }
}

