/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.data.shared.overlay.BitmapOverlayShrink;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.AbstractOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ByteOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.GraphicsOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IntOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ShortOverlayRenderer;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class StringOverlayData
implements IOverlayData {
    private final byte[] data;
    private final int width;
    private final int height;

    public StringOverlayData(byte[] byArray, int n, int n2) {
        this.data = byArray;
        this.width = n;
        this.height = n2;
    }

    @Override
    public int getHeight() {
        return this.height;
    }

    @Override
    public int getWidth() {
        return this.width;
    }

    @Override
    public void renderTo(int n, int n2, Graphics graphics) {
        BitmapOverlayShrink bitmapOverlayShrink = new BitmapOverlayShrink(this.height, this.width, new int[2]);
        GraphicsOverlayRenderer graphicsOverlayRenderer = new GraphicsOverlayRenderer(n, n2, graphics);
        int n3 = 0;
        while (n3 < this.height) {
            byte[] byArray = bitmapOverlayShrink.getPaddedLine(this.data, n3, this.width, this.height);
            graphicsOverlayRenderer.drawLine(byArray, this.width);
            ++n3;
        }
    }

    @Override
    public void renderTo(int n, int n2, Object object, int n3, int n4) {
        AbstractOverlayRenderer abstractOverlayRenderer = null;
        if (object instanceof DataBufferByte) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, ((DataBufferByte)object).getData(), n3, (byte)n4);
        }
        if (object instanceof DataBufferShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferUShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferUShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferInt) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, (byte[])object, n3, (byte)n4);
        }
        if (object instanceof short[]) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, (short[])object, n3, (byte)n4);
        }
        if (object instanceof int[]) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, (int[])object, n3, n4);
        }
        int n5 = this.width / 8;
        if (this.width % 8 > 0) {
            ++n5;
        }
        int n6 = 0;
        while (n6 < this.height) {
            byte[] byArray = Arrays.copyOfRange(this.data, n6 * this.width / 8, n6 * this.width / 8 + n5);
            abstractOverlayRenderer.drawLine(byArray, this.width);
            ++n6;
        }
    }

    @Override
    public byte[] toPackedBits() {
        return this.data;
    }

    public void writePackedBits(BitWriter bitWriter) {
    }

    @Override
    public void writePackedBits(BitWriter bitWriter, int n, int n2, int n3, int n4, int n5) {
    }
}

