/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.RLEOverlayData;
import java.io.ByteArrayOutputStream;

public class RLEOverlayDataWriter
implements IOverlayDataWriter {
    private ByteArrayOutputStream outputStream;
    private int prevByte;
    private int count;

    @Override
    public final void end() {
        if (this.prevByte >= 0 && this.count > 0) {
            this.outputStream.write(this.count);
            this.outputStream.write(this.prevByte);
        }
        this.outputStream.write(126);
        this.count = 0;
    }

    @Override
    public final IOverlayData getOverlayData(int n, int n2) {
        return new RLEOverlayData(this.outputStream.toByteArray(), n, n2);
    }

    @Override
    public final void nextLine() {
        if (this.prevByte >= 0 && this.count > 0) {
            this.outputStream.write(this.count);
            this.outputStream.write(this.prevByte);
        }
        this.outputStream.write(127);
        this.count = 0;
    }

    @Override
    public final void setBit(int n) {
        if ((n &= 1) == this.prevByte) {
            ++this.count;
            if (this.count == 125) {
                this.outputStream.write(this.count);
                this.outputStream.write(this.prevByte);
                this.count = 0;
            }
        } else {
            if (this.prevByte >= 0 && this.count > 0) {
                this.outputStream.write(this.count);
                this.outputStream.write(this.prevByte);
            }
            this.prevByte = n;
            this.count = 1;
        }
    }

    @Override
    public final void fillBits(int n, int n2) {
        int n3 = 0;
        while (n3 < n2) {
            this.setBit(n);
            ++n3;
        }
    }

    @Override
    public final void setBits(byte[] byArray, int n) {
        BitReader bitReader = new BitReader(byArray);
        int n2 = 0;
        while (n2 < n) {
            this.setBit(bitReader.getBit());
            ++n2;
        }
    }

    @Override
    public final void start() {
        this.outputStream = new ByteArrayOutputStream();
        this.prevByte = -1;
        this.count = 0;
    }
}

