/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataLine;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.util.Arrays;

public class RLEOverlayData
implements IOverlayData {
    public static final byte EOI = 126;
    public static final byte EOL = 127;
    private final byte[] dataRLE;
    private final int width;
    private final int height;
    private int[] lineOffsets;

    public RLEOverlayData(byte[] byArray, int n, int n2) {
        this.dataRLE = byArray;
        this.width = n;
        this.height = n2;
        this.lineOffsets = null;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void renderTo(int n, int n2, Graphics graphics) {
        byte by;
        int n3 = n;
        int n4 = n2;
        int n5 = 0;
        block3: while ((by = this.dataRLE[n5++]) != 126) {
            switch (by) {
                case 127: {
                    n3 = n;
                    ++n4;
                    continue block3;
                }
            }
            byte by2 = this.dataRLE[n5++];
            if (by2 == 1) {
                graphics.fillRect(n3, n4, by, 1);
            }
            n3 += by;
        }
    }

    @Override
    public final void renderTo(int n, int n2, Object object, int n3, int n4) {
        if (object instanceof DataBufferByte) {
            this.renderTo(n, n2, ((DataBufferByte)object).getData(), n3, n4);
        }
        if (object instanceof DataBufferShort) {
            this.renderTo(n, n2, ((DataBufferShort)object).getData(), n3, n4);
        }
        if (object instanceof DataBufferUShort) {
            this.renderTo(n, n2, ((DataBufferUShort)object).getData(), n3, n4);
        }
        if (object instanceof DataBufferInt) {
            this.renderTo(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            this.renderTo(n, n2, (byte[])object, n3, n4);
        }
        if (object instanceof short[]) {
            this.renderTo(n, n2, (short[])object, n3, n4);
        }
        if (object instanceof int[]) {
            this.renderTo(n, n2, (int[])object, n3, n4);
        }
    }

    private final void renderTo(int n, int n2, byte[] byArray, int n3, int n4) {
        byte by;
        int n5;
        int n6 = n5 = n2 * n3 + n;
        int n7 = 0;
        block3: while ((by = this.dataRLE[n7++]) != 126) {
            switch (by) {
                case 127: {
                    n6 = n5 += n3;
                    continue block3;
                }
            }
            byte by2 = this.dataRLE[n7++];
            if (by2 == 1) {
                Arrays.fill(byArray, n6, n6 + by, (byte)n4);
            }
            n6 += by;
        }
    }

    private final void renderTo(int n, int n2, short[] sArray, int n3, int n4) {
        byte by;
        int n5;
        int n6 = n5 = n2 * n3 + n;
        int n7 = 0;
        block3: while ((by = this.dataRLE[n7++]) != 126) {
            switch (by) {
                case 127: {
                    n6 = n5 += n3;
                    continue block3;
                }
            }
            byte by2 = this.dataRLE[n7++];
            if (by2 == 1) {
                Arrays.fill(sArray, n6, n6 + by, (short)n4);
            }
            n6 += by;
        }
    }

    private final void renderTo(int n, int n2, int[] nArray, int n3, int n4) {
        byte by;
        int n5;
        int n6 = n5 = n2 * n3 + n;
        int n7 = 0;
        block3: while ((by = this.dataRLE[n7++]) != 126) {
            switch (by) {
                case 127: {
                    n6 = n5 += n3;
                    continue block3;
                }
            }
            byte by2 = this.dataRLE[n7++];
            if (by2 == 1) {
                Arrays.fill(nArray, n6, n6 + by, n4);
            }
            n6 += by;
        }
    }

    @Override
    public final byte[] toPackedBits() {
        BitWriter bitWriter = new BitWriter();
        this.writePackedBits(bitWriter);
        return bitWriter.toBytes();
    }

    public final void writePackedBits(BitWriter bitWriter) {
        byte by;
        int n = 0;
        while ((by = this.dataRLE[n++]) != 126) {
            if (by == 127) continue;
            byte by2 = this.dataRLE[n++];
            bitWriter.writeBit((int)by2, (int)by);
        }
    }

    @Override
    public final void writePackedBits(BitWriter bitWriter, int n, int n2, int n3, int n4, int n5) {
        byte by;
        int n6 = 0;
        bitWriter.writeBit(0, n * n4);
        bitWriter.writeBit(0, n2);
        while ((by = this.dataRLE[n6++]) != 126) {
            if (by != 127) {
                byte by2 = this.dataRLE[n6++];
                bitWriter.writeBit((int)by2, (int)by);
                continue;
            }
            bitWriter.writeBit(0, n3);
            if (this.dataRLE[n6 + 1] == 126) continue;
            bitWriter.writeBit(0, n2);
        }
        bitWriter.writeBit(0, n * n5);
    }

    public final byte[] toPaddedLineBits() {
        BitWriter bitWriter = new BitWriter();
        this.writePaddedLineBits(bitWriter);
        return bitWriter.toBytes();
    }

    public final void writePaddedLineBits(BitWriter bitWriter) {
        byte by;
        int n = 0;
        while ((by = this.dataRLE[n++]) != 126) {
            if (by != 127) {
                byte by2 = this.dataRLE[n++];
                bitWriter.writeBit((int)by2, (int)by);
                continue;
            }
            bitWriter.flush();
        }
    }

    public final IOverlayDataLine getLine(int n) {
        if (this.lineOffsets == null) {
            byte by;
            this.lineOffsets = new int[this.height];
            int n2 = 0;
            int n3 = 0;
            this.lineOffsets[n3] = 0;
            ++n3;
            while ((by = this.dataRLE[n2++]) != 126) {
                if (by != 127) {
                    ++n2;
                    continue;
                }
                if (n3 >= this.height) continue;
                this.lineOffsets[n3] = n2;
                ++n3;
            }
        }
        return new OverlayDataLine(this.dataRLE, this.lineOffsets[n]);
    }

    private final class OverlayDataLine
    implements IOverlayDataLine {
        private final int offset;
        private final byte[] dataRLE;
        private byte[] data;

        public OverlayDataLine(byte[] byArray, int n) {
            this.dataRLE = byArray;
            this.offset = n;
        }

        @Override
        public final int getBit(int n) {
            byte by;
            if (this.data == null) {
                this.data = this.getData();
            }
            if ((by = this.data[n >> 3]) == 0) {
                return 0;
            }
            if (by == -128) {
                return 1;
            }
            return by >> (n & 7) & 1;
        }

        @Override
        public final int getPosOfFirstBit() {
            int n = this.offset;
            int n2 = 0;
            byte by;
            while ((by = this.dataRLE[n++]) != 126) {
                byte by2;
                if (by == 127) {
                    return RLEOverlayData.this.width;
                }
                if ((by2 = this.dataRLE[n++]) != 0) {
                    return n2;
                }
                n2 += by;
            }
            return RLEOverlayData.this.width;
        }

        @Override
        public final int getPosOfLastBit() {
            int n = this.offset;
            int n2 = 0;
            int n3 = -1;
            byte by;
            while ((by = this.dataRLE[n++]) != 126) {
                if (by == 127) {
                    return n3;
                }
                byte by2 = this.dataRLE[n++];
                n2 += by;
                if (by2 == 0) continue;
                n3 = n2;
            }
            return n3;
        }

        @Override
        public final byte[] getData() {
            byte by;
            BitWriter bitWriter = new BitWriter();
            int n = this.offset;
            while ((by = this.dataRLE[n++]) != 126 && by != 127) {
                byte by2 = this.dataRLE[n++];
                bitWriter.writeBit((int)by2, (int)by);
            }
            return bitWriter.toBytes();
        }
    }
}

