/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.data.shared.pixel.IPixelDataFrame;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.EmptyOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataFactory;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.PaddedOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.PaddedOverlayDataWriter;
import com.agfa.pacs.logging.ALogger;
import java.io.ByteArrayOutputStream;

public class PaddedOverlayDataFactory
implements IOverlayDataFactory {
    private static final ALogger logger = ALogger.getLogger(PaddedOverlayDataFactory.class);

    @Override
    public IOverlayData createOverlayData(byte[] byArray, int n, int n2, int n3) {
        try {
            BitReader bitReader = new BitReader(byArray, n * n2 * n3);
            ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
            int n4 = 0;
            while (n4 < n2) {
                byte[] byArray2 = bitReader.getBits(n);
                byteArrayOutputStream.write(byArray2);
                ++n4;
            }
            return new PaddedOverlayData(byteArrayOutputStream.toByteArray(), n, n2);
        }
        catch (Exception exception) {
            logger.error("Error creating overlay data - returning empty instance", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }

    @Override
    public IOverlayData createOverlayData(IPixelDataFrame iPixelDataFrame, int n) {
        try {
            int n2;
            int n3;
            Object[] objectArray;
            int n4;
            Object object = iPixelDataFrame.getOriginalData();
            BitWriter bitWriter = new BitWriter();
            int n5 = iPixelDataFrame.getWidth();
            int n6 = iPixelDataFrame.getHeight();
            if (object instanceof byte[]) {
                n4 = 0;
                objectArray = (byte[])object;
                n3 = 0;
                while (n3 < n6) {
                    n2 = 0;
                    while (n2 < n5) {
                        bitWriter.writeBit(objectArray[n4++] >> n & 1);
                        ++n2;
                    }
                    bitWriter.flush();
                    ++n3;
                }
            }
            if (object instanceof short[]) {
                n4 = 0;
                objectArray = (short[])object;
                n3 = 0;
                while (n3 < n6) {
                    n2 = 0;
                    while (n2 < n5) {
                        bitWriter.writeBit(objectArray[n4++] >> n & 1);
                        ++n2;
                    }
                    bitWriter.flush();
                    ++n3;
                }
            }
            iPixelDataFrame.releaseOriginalData(object);
            return new PaddedOverlayData(bitWriter.toBytes(), n5, n6);
        }
        catch (Exception exception) {
            logger.error("Error creating overlay data - returning empty instance", (Throwable)exception);
            return new EmptyOverlayData();
        }
    }

    @Override
    public IOverlayDataWriter createOverlayDataWriter() {
        return new PaddedOverlayDataWriter();
    }
}

