/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.listtext.dicomobject.presentation.overlay;

import com.agfa.pacs.data.shared.BitReader;
import com.agfa.pacs.data.shared.BitWriter;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.AbstractOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ByteOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.GraphicsOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayData;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IOverlayDataLine;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.IntOverlayRenderer;
import com.agfa.pacs.listtext.dicomobject.presentation.overlay.ShortOverlayRenderer;
import com.agfa.pacs.logging.ALogger;
import java.awt.Graphics;
import java.awt.image.DataBufferByte;
import java.awt.image.DataBufferInt;
import java.awt.image.DataBufferShort;
import java.awt.image.DataBufferUShort;
import java.io.ByteArrayOutputStream;
import java.io.IOException;

public class PackedOverlayData
implements IOverlayData {
    private static final ALogger logger = ALogger.getLogger(PackedOverlayData.class);
    private final byte[] data;
    private final int width;
    private final int height;
    private final int offset;

    public PackedOverlayData(byte[] byArray, int n, int n2, int n3) {
        this.data = byArray;
        this.width = n2;
        this.height = n3;
        this.offset = n;
    }

    @Override
    public final int getHeight() {
        return this.height;
    }

    @Override
    public final int getWidth() {
        return this.width;
    }

    @Override
    public final void renderTo(int n, int n2, Graphics graphics) {
        GraphicsOverlayRenderer graphicsOverlayRenderer = new GraphicsOverlayRenderer(n, n2, graphics);
        BitReader bitReader = new BitReader(this.data, this.offset);
        int n3 = 0;
        while (n3 < this.height) {
            byte[] byArray = bitReader.getBits(this.width);
            graphicsOverlayRenderer.drawLine(byArray, this.width);
            ++n3;
        }
    }

    @Override
    public final void renderTo(int n, int n2, Object object, int n3, int n4) {
        AbstractOverlayRenderer abstractOverlayRenderer = null;
        if (object instanceof DataBufferByte) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, ((DataBufferByte)object).getData(), n3, (byte)n4);
        }
        if (object instanceof DataBufferShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferUShort) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, ((DataBufferUShort)object).getData(), n3, (short)n4);
        }
        if (object instanceof DataBufferInt) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, ((DataBufferInt)object).getData(), n3, n4);
        }
        if (object instanceof byte[]) {
            abstractOverlayRenderer = new ByteOverlayRenderer(n, n2, (byte[])object, n3, (byte)n4);
        }
        if (object instanceof short[]) {
            abstractOverlayRenderer = new ShortOverlayRenderer(n, n2, (short[])object, n3, (byte)n4);
        }
        if (object instanceof int[]) {
            abstractOverlayRenderer = new IntOverlayRenderer(n, n2, (int[])object, n3, n4);
        }
        BitReader bitReader = new BitReader(this.data, this.offset);
        int n5 = 0;
        while (n5 < this.height) {
            byte[] byArray = bitReader.getBits(this.width);
            abstractOverlayRenderer.drawLine(byArray, this.width);
            ++n5;
        }
    }

    @Override
    public final byte[] toPackedBits() {
        return this.data;
    }

    public final byte[] toPaddedLineBits() {
        BitReader bitReader = new BitReader(this.data, this.offset);
        ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream();
        try {
            int n = 0;
            while (n < this.height) {
                byte[] byArray = bitReader.getBits(this.width);
                byteArrayOutputStream.write(byArray);
                ++n;
            }
        }
        catch (IOException iOException) {
            logger.error("Error while converting to padded line bits", (Throwable)iOException);
        }
        return byteArrayOutputStream.toByteArray();
    }

    public final void writePackedBits(BitWriter bitWriter) {
        bitWriter.writeBits(this.data, this.width * this.height);
    }

    @Override
    public final void writePackedBits(BitWriter bitWriter, int n, int n2, int n3, int n4, int n5) {
        bitWriter.writeBit(0, n * n4);
        int n6 = 0;
        while (n6 < this.height) {
            bitWriter.writeBit(0, n2);
            bitWriter.writeBits(this.data, n6 * this.width, this.width);
            bitWriter.writeBit(0, n3);
            ++n6;
        }
        bitWriter.writeBit(0, n * n5);
    }

    public final IOverlayDataLine getLine(int n) {
        return new OverlayDataLine(this.offset + n * this.width);
    }

    private final class OverlayDataLine
    implements IOverlayDataLine {
        private final int lineOffset;

        public OverlayDataLine(int n) {
            this.lineOffset = n;
        }

        @Override
        public final int getBit(int n) {
            int n2 = this.lineOffset + n;
            byte by = PackedOverlayData.this.data[n2 >> 3];
            if (by == 0) {
                return 0;
            }
            return by >> (n2 & 7) & 1;
        }

        @Override
        public final int getPosOfFirstBit() {
            int n = 0;
            while (n < PackedOverlayData.this.width) {
                if (this.getBit(n) != 0) break;
                ++n;
            }
            return n;
        }

        @Override
        public final int getPosOfLastBit() {
            int n = PackedOverlayData.this.width - 1;
            while (n >= 0) {
                if (this.getBit(n) != 0) break;
                --n;
            }
            return n;
        }

        @Override
        public final byte[] getData() {
            BitReader bitReader = new BitReader(PackedOverlayData.this.data, PackedOverlayData.this.offset);
            return bitReader.getBits(PackedOverlayData.this.width);
        }
    }
}

