/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.instrumentation;

import com.agfa.pacs.core.FactorySelector;
import com.agfa.pacs.instrumentation.IInstrumentor;
import org.apache.log4j.Level;

public abstract class InstrumentorFactory {
    private static InstrumentorFactory implementation;

    public static synchronized IInstrumentor getInstrumentor() {
        if (implementation == null) {
            InstrumentorFactory.initialize();
        }
        return implementation.getInstrumentorInt();
    }

    protected abstract IInstrumentor getInstrumentorInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(InstrumentorFactory.class.getName()));
            implementation = (InstrumentorFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + InstrumentorFactory.class.getName(), reflectiveOperationException);
        }
    }

    protected class DummyInstrumentor
    implements IInstrumentor {
        protected DummyInstrumentor() {
        }

        @Override
        public String createTUID() {
            return "---";
        }

        @Override
        public String createTUID(String string) {
            return "---";
        }

        @Override
        public void record(String string, String string2, String string3, long l, String string4, Level level) {
        }

        @Override
        public void recordStart(String string, String string2, long l, String string3, Level level) {
        }

        @Override
        public void recordStart(String string, String string2, String string3, Level level) {
        }

        @Override
        public void recordStop(String string, String string2, long l, String string3, Level level) {
        }

        @Override
        public void recordStop(String string, String string2, String string3, Level level) {
        }

        @Override
        public void record(String string, String string2, String string3, String string4, Level level) {
        }

        @Override
        public String getCurrentKPITransactionUID() {
            return null;
        }

        @Override
        public void recordKPI(String string, String string2, long l, String string3) {
        }

        @Override
        public void setCurrentKPITransactionUID(String string) {
        }

        @Override
        public Level getCurrentInstrumentationLevel() {
            return Level.OFF;
        }
    }
}

