/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.event;

import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;

public class EventEngineUtil {
    private static final EventEngineUtil singletonHolder = new EventEngineUtil();
    private IEventEngine eventEngine;

    public static EventEngineUtil getInstance() {
        return singletonHolder;
    }

    private IEventEngine getEventEngine() {
        if (this.eventEngine == null) {
            this.eventEngine = EventEngineFactory.getInstance();
        }
        return this.eventEngine;
    }

    public void setEventEngine(IEventEngine iEventEngine) {
        this.eventEngine = iEventEngine;
    }

    public void sendEvent(int n, String string, Object object) {
        IEvent iEvent = this.getEventEngine().createEvent(n);
        iEvent.setDestination(null, string);
        iEvent.setPayload(object);
        this.getEventEngine().sendEvent(iEvent);
    }

    public void sendInternalEvent(int n, String string, Object object) {
        IEvent iEvent = this.getEventEngine().createInternalEvent(n);
        iEvent.setDestination(null, string);
        iEvent.setPayload(object);
        this.getEventEngine().sendEvent(iEvent);
    }
}

