/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.core;

import com.agfa.pacs.logging.ALogger;
import com.agfa.pacs.tools.StreamUtil;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.StringReader;
import java.net.URL;
import java.nio.charset.Charset;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import org.w3c.dom.Document;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import org.xml.sax.InputSource;

public class PluginXMLParser {
    private static final ALogger LOG = ALogger.getLogger(PluginXMLParser.class);
    private static final Map<String, Document> pluginXMLS = Collections.synchronizedMap(new HashMap(256));
    private static final DocumentBuilderFactory dbFactory = DocumentBuilderFactory.newInstance();

    static {
        try {
            Enumeration<URL> enumeration = PluginXMLParser.class.getClassLoader().getResources("/plugin.xml");
            while (enumeration.hasMoreElements()) {
                URL uRL = enumeration.nextElement();
                InputStreamReader inputStreamReader = new InputStreamReader(uRL.openStream(), Charset.defaultCharset());
                String string = StreamUtil.readStream(inputStreamReader);
                pluginXMLS.put(string, null);
            }
        }
        catch (IOException iOException) {
            LOG.error("Could not read plugin xml", (Throwable)iOException);
        }
    }

    public static NamedNodeMap getExtensionConfiguration(Class<?> clazz) {
        String string = clazz.getName();
        for (Map.Entry<String, Document> entry : pluginXMLS.entrySet()) {
            if (!entry.getKey().contains(string)) continue;
            if (entry.getValue() == null) {
                try {
                    DocumentBuilder documentBuilder = dbFactory.newDocumentBuilder();
                    Document document = documentBuilder.parse(new InputSource(new StringReader(entry.getKey())));
                    pluginXMLS.put(entry.getKey(), document);
                    return PluginXMLParser.getProperty(document, string);
                }
                catch (Exception exception) {
                    LOG.error("Could not parse plugin XML", (Throwable)exception);
                    continue;
                }
            }
            return PluginXMLParser.getProperty(entry.getValue(), string);
        }
        return null;
    }

    public static String getExtensionProperty(Class<?> clazz, String string) {
        NamedNodeMap namedNodeMap = PluginXMLParser.getExtensionConfiguration(clazz);
        if (namedNodeMap != null) {
            Node node = namedNodeMap.getNamedItem(string);
            if (node != null) {
                return node.getNodeValue();
            }
            return null;
        }
        return null;
    }

    private static NamedNodeMap getProperty(Document document, String string) {
        NodeList nodeList = document.getElementsByTagName("extension");
        int n = 0;
        while (n < nodeList.getLength()) {
            NodeList nodeList2 = nodeList.item(n).getChildNodes();
            int n2 = 0;
            while (n2 < nodeList2.getLength()) {
                Node node = nodeList2.item(n2);
                if (node.getAttributes().getNamedItem("class").getNodeValue().equalsIgnoreCase(string)) {
                    return node.getAttributes();
                }
                ++n2;
            }
            ++n;
        }
        LOG.info("Not found extension {}", (Object)string);
        return null;
    }
}

