/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.core;

import com.agfa.pacs.core.ApplicationType;
import com.agfa.pacs.core.IApplicationManagement;
import com.agfa.pacs.core.PrepareForStateChangeSynchronizer;
import com.agfa.pacs.core.app.ApplicationInformationFactory;
import com.agfa.pacs.event.ActionInfo;
import com.agfa.pacs.event.EventEngineFactory;
import com.agfa.pacs.event.IEvent;
import com.agfa.pacs.event.IEventEngine;
import org.eclipse.equinox.app.IApplication;

public class ApplicationManagement
implements IApplicationManagement {
    private static IApplicationManagement instance = new ApplicationManagement();
    private static IEventEngine fac = EventEngineFactory.getInstance();
    private Integer returnCode = IApplication.EXIT_OK;
    public static final int APP_REQUEST_SHUTDOWN = fac.getEventID("com.agfa.pacs.client.requestshutdown");
    public static final int APP_PREPARE_SHUTDOWN = fac.getEventID("com.agfa.pacs.client.prepareshutdown");
    public static final int APP_SHUTDOWN = fac.getEventID("com.agfa.pacs.client.shutdown");
    public static final int APP_MEMORY_PANIC = fac.getEventID("com.agfa.pacs.client.memorypanic");
    public static final String LISTENER_GROUP = "application.management";
    private static final String SHUTDOWN_THREAD_NAME = "Shutdown Thread";
    private boolean terminated = false;
    private boolean isShuttingDown;
    private ApplicationType type = ApplicationInformationFactory.getInstance().getApplicationInformation().getType();

    public static IApplicationManagement getInstance() {
        return instance;
    }

    @Override
    public ApplicationType getApplicationType() {
        return this.type;
    }

    private ApplicationManagement() {
    }

    @Override
    public boolean isShuttingDown() {
        return this.isShuttingDown;
    }

    @Override
    public synchronized void shutdown(final boolean bl) {
        if (this.isShuttingDown) {
            return;
        }
        this.isShuttingDown = true;
        new Thread(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                PrepareForStateChangeSynchronizer.waitForStateChange(APP_REQUEST_SHUTDOWN, null);
                IEvent iEvent = fac.createEvent(APP_PREPARE_SHUTDOWN);
                iEvent.setActionInfo(ActionInfo.SINGLE);
                iEvent.setDestination(null, ApplicationManagement.LISTENER_GROUP);
                fac.sendExclusiveEvent(iEvent);
                iEvent = fac.createEvent(APP_SHUTDOWN);
                iEvent.setActionInfo(ActionInfo.SINGLE);
                iEvent.setDestination(null, ApplicationManagement.LISTENER_GROUP);
                fac.sendBlockingEvent(iEvent);
                ApplicationManagement applicationManagement = ApplicationManagement.this;
                synchronized (applicationManagement) {
                    if (bl) {
                        ApplicationManagement.this.returnCode = IApplication.EXIT_RESTART;
                    }
                    ApplicationManagement.this.terminated = true;
                    ApplicationManagement.this.notifyAll();
                }
            }
        }, SHUTDOWN_THREAD_NAME).start();
    }

    @Override
    public synchronized Integer waitForTermination() {
        while (!this.terminated) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {}
        }
        return this.returnCode;
    }
}

