/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.background;

import com.agfa.pacs.background.IBackgroundTaskEngine;
import com.agfa.pacs.core.FactorySelector;

public abstract class BackgroundTaskEngineFactory {
    private static BackgroundTaskEngineFactory implementation;

    public static synchronized IBackgroundTaskEngine getInstance() {
        if (implementation == null) {
            BackgroundTaskEngineFactory.initialize();
        }
        return implementation.getEngineInt();
    }

    protected abstract IBackgroundTaskEngine getEngineInt();

    private static synchronized void initialize() {
        ReflectiveOperationException reflectiveOperationException = null;
        try {
            Class<?> clazz = Class.forName(FactorySelector.createFactory(BackgroundTaskEngineFactory.class.getName()));
            implementation = (BackgroundTaskEngineFactory)clazz.newInstance();
        }
        catch (ClassNotFoundException classNotFoundException) {
            reflectiveOperationException = classNotFoundException;
        }
        catch (InstantiationException instantiationException) {
            reflectiveOperationException = instantiationException;
        }
        catch (IllegalAccessException illegalAccessException) {
            reflectiveOperationException = illegalAccessException;
        }
        if (reflectiveOperationException != null) {
            throw new RuntimeException("failed to create factory " + BackgroundTaskEngineFactory.class.getName(), reflectiveOperationException);
        }
    }
}

