/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.pacs.math;

import javax.vecmath.Matrix4d;
import javax.vecmath.Point3d;
import javax.vecmath.Point4d;
import javax.vecmath.Tuple2d;
import javax.vecmath.Tuple3d;
import javax.vecmath.Tuple4d;
import javax.vecmath.Vector2d;
import javax.vecmath.Vector3d;
import javax.vecmath.Vector4d;

public class GeomUtil {
    public static final Vector3d projectToPlane(Tuple3d tuple3d, double[] dArray, double[] dArray2) {
        if (dArray == null || dArray2 == null) {
            return null;
        }
        Vector3d vector3d = new Vector3d(dArray);
        Vector3d vector3d2 = new Vector3d(dArray2[0], dArray2[1], dArray2[2]);
        Vector3d vector3d3 = new Vector3d(dArray2[3], dArray2[4], dArray2[5]);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d2, vector3d3);
        Vector3d vector3d5 = new Vector3d(tuple3d);
        vector3d5.sub((Tuple3d)vector3d);
        Vector3d vector3d6 = new Vector3d(vector3d4);
        vector3d6.normalize();
        double d = vector3d6.dot(vector3d5);
        vector3d6.scale(d);
        vector3d5.set(tuple3d);
        vector3d5.sub((Tuple3d)vector3d6);
        return vector3d5;
    }

    public static final Vector3d projectToPlane(Tuple3d tuple3d, Point3d point3d, Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d((Tuple3d)point3d);
        Vector3d vector3d4 = new Vector3d();
        vector3d4.cross(vector3d, vector3d2);
        Vector3d vector3d5 = new Vector3d(tuple3d);
        vector3d5.sub((Tuple3d)vector3d3);
        Vector3d vector3d6 = new Vector3d(vector3d4);
        vector3d6.normalize();
        double d = vector3d6.dot(vector3d5);
        vector3d6.scale(d);
        vector3d5.set(tuple3d);
        vector3d5.sub((Tuple3d)vector3d6);
        return vector3d5;
    }

    public static Vector3d projectToPlane(Tuple3d tuple3d, Point3d point3d, Point3d point3d2, Point3d point3d3) {
        Vector3d vector3d = new Vector3d((Tuple3d)point3d2);
        vector3d.sub((Tuple3d)point3d);
        Vector3d vector3d2 = new Vector3d((Tuple3d)point3d3);
        vector3d2.sub((Tuple3d)point3d);
        return GeomUtil.projectToPlane(tuple3d, point3d, vector3d, vector3d2);
    }

    public static final Point4d projectToPlane(Point4d point4d, Point3d point3d, Vector3d vector3d) {
        vector3d.normalize();
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        double d4 = -(d * point3d.x + d2 * point3d.y + d3 * point3d.z);
        double d5 = -(d4 / (d * d + d2 * d2 + d3 * d3));
        Vector4d vector4d = new Vector4d(d * d5, d2 * d5, d3 * d5, 0.0);
        Point4d point4d2 = new Point4d(point4d);
        point4d2.sub((Tuple4d)vector4d);
        double d6 = d2 * d2 + d3 * d3;
        double d7 = -(d * d2);
        double d8 = -(d * d3);
        double d9 = -(d2 * d);
        double d10 = d * d + d3 * d3;
        double d11 = -(d2 * d3);
        double d12 = -(d3 * d);
        double d13 = -(d3 * d2);
        double d14 = d * d + d2 * d2;
        double d15 = point4d2.x * d6 + point4d2.y * d9 + point4d2.z * d12;
        double d16 = point4d2.x * d7 + point4d2.y * d10 + point4d2.z * d13;
        double d17 = point4d2.x * d8 + point4d2.y * d11 + point4d2.z * d14;
        point4d2.set(d15, d16, d17, 0.0);
        point4d2.add((Tuple4d)vector4d);
        return point4d2;
    }

    public static final Vector3d projectToPlane(Tuple3d tuple3d, Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d(tuple3d);
        vector3d2.sub((Tuple3d)point3d);
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.normalize();
        double d = vector3d3.dot(vector3d2);
        vector3d3.scale(d);
        vector3d2.set(tuple3d);
        vector3d2.sub((Tuple3d)vector3d3);
        return vector3d2;
    }

    public static final Vector3d projectToPlane(Point3d point3d, Point3d point3d2, Vector3d vector3d) {
        Vector3d vector3d2 = new Vector3d((Tuple3d)point3d);
        vector3d2.sub((Tuple3d)point3d2);
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.normalize();
        double d = vector3d3.dot(vector3d2);
        vector3d3.scale(d);
        vector3d2.set((Tuple3d)point3d);
        vector3d2.sub((Tuple3d)vector3d3);
        return vector3d2;
    }

    public static final double getDistanceFromPlane(Tuple3d tuple3d, double[] dArray, double[] dArray2) {
        Vector3d vector3d = GeomUtil.projectToPlane(tuple3d, dArray, dArray2);
        if (vector3d == null) {
            return Double.NaN;
        }
        vector3d.sub(tuple3d);
        return vector3d.length();
    }

    public static final double getDistanceFromPlane(Tuple3d tuple3d, Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = GeomUtil.projectToPlane(tuple3d, point3d, vector3d);
        vector3d2.sub(tuple3d);
        return vector3d2.length();
    }

    public static final double getSignedDistanceFromPlane(Tuple3d tuple3d, Point3d point3d, Vector3d vector3d) {
        Vector3d vector3d2 = GeomUtil.projectToPlane(tuple3d, point3d, vector3d);
        vector3d2.sub(tuple3d);
        Vector3d vector3d3 = new Vector3d(vector3d);
        return vector3d2.length() * Math.signum(vector3d3.dot(vector3d2));
    }

    public static final double getSignedDistanceFromLine(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = -(d4 - d2);
        double d8 = d3 - d;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = d3 * (d7 /= d9) + d4 * (d8 /= d9);
        return d5 * d7 + d6 * d8 - d10;
    }

    public static final double getDistanceFromLine(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8, double d9) {
        Vector3d vector3d = new Vector3d(d4 - d, d5 - d2, d6 - d3);
        Vector3d vector3d2 = new Vector3d(d7 - d, d8 - d2, d9 - d3);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        return vector3d3.length() / vector3d.length();
    }

    public static final Vector3d intersectLineAndPlane(Point3d point3d, Vector3d vector3d, Point3d point3d2, Point3d point3d3) {
        Vector3d vector3d2 = new Vector3d();
        vector3d2.sub((Tuple3d)point3d3, (Tuple3d)point3d2);
        double d = vector3d2.dot(vector3d);
        if (d == 0.0) {
            return null;
        }
        vector3d2.scale(vector3d.dot(new Vector3d(point3d.x - point3d2.x, point3d.y - point3d2.y, point3d.z - point3d2.z)) / d);
        vector3d2.add((Tuple3d)point3d2);
        return vector3d2;
    }

    public static final Vector3d intersectLineAndPlane(Tuple3d tuple3d, Vector3d vector3d, Tuple3d tuple3d2, Vector4d vector4d) {
        Vector3d vector3d2 = new Vector3d(vector4d.x, vector4d.y, vector4d.z);
        double d = vector3d2.dot(vector3d);
        if (d == 0.0) {
            return null;
        }
        vector3d2.scale(vector3d.dot(new Vector3d(tuple3d.x - tuple3d2.x, tuple3d.y - tuple3d2.y, tuple3d.z - tuple3d2.z)) / d);
        vector3d2.add(tuple3d2);
        return vector3d2;
    }

    public static final boolean isEqualyOriented(Vector3d vector3d, Vector3d vector3d2) {
        Vector3d vector3d3 = new Vector3d(vector3d);
        vector3d3.add((Tuple3d)vector3d2);
        double d = vector3d3.length();
        Vector3d vector3d4 = new Vector3d(vector3d);
        vector3d4.sub((Tuple3d)vector3d2);
        double d2 = vector3d4.length();
        return d > d2;
    }

    public static final Vector2d projectToLine(double d, double d2, double d3, double d4, double d5, double d6) {
        double d7 = d3 - d;
        double d8 = d4 - d2;
        double d9 = Math.sqrt(d7 * d7 + d8 * d8);
        double d10 = (d5 - d) * (d7 /= d9) + (d6 - d2) * (d8 /= d9);
        return new Vector2d(d + d10 * d7, d2 + d10 * d8);
    }

    public static final Vector4d crossProduct3D(Tuple4d tuple4d, Tuple4d tuple4d2) {
        return new Vector4d(tuple4d.y * tuple4d2.z - tuple4d.z * tuple4d2.y, tuple4d.z * tuple4d2.x - tuple4d.x * tuple4d2.z, tuple4d.x * tuple4d2.y - tuple4d.y * tuple4d2.x, 1.0);
    }

    public static final double getAngle(double d, double d2, double d3, double d4) {
        double d5 = (d * d3 + d2 * d4) / Math.sqrt((d * d + d2 * d2) * (d3 * d3 + d4 * d4));
        double d6 = -d2 * d3 + d * d4;
        if (d6 > 0.0) {
            return Math.acos(d5);
        }
        return Math.PI * 2 - Math.acos(d5);
    }

    public static final Vector2d intersectLineAndLine2D(Tuple2d tuple2d, Tuple2d tuple2d2, Tuple2d tuple2d3, Tuple2d tuple2d4) {
        double d = ((tuple2d4.x - tuple2d3.x) * (tuple2d.y - tuple2d3.y) - (tuple2d4.y - tuple2d3.y) * (tuple2d.x - tuple2d3.x)) / ((tuple2d4.y - tuple2d3.y) * (tuple2d2.x - tuple2d.x) - (tuple2d4.x - tuple2d3.x) * (tuple2d2.y - tuple2d.y));
        double d2 = ((tuple2d2.x - tuple2d.x) * (tuple2d.y - tuple2d3.y) - (tuple2d2.y - tuple2d.y) * (tuple2d.x - tuple2d3.x)) / ((tuple2d4.y - tuple2d3.y) * (tuple2d2.x - tuple2d.x) - (tuple2d4.x - tuple2d3.x) * (tuple2d2.y - tuple2d.y));
        return new Vector2d(tuple2d.x + d * (tuple2d2.x - tuple2d.x), tuple2d3.y + d2 * (tuple2d4.y - tuple2d3.y));
    }

    public static final Vector2d intersectLineSegmentAndLineSegment2D(Tuple2d tuple2d, Tuple2d tuple2d2, Tuple2d tuple2d3, Tuple2d tuple2d4) {
        double d = ((tuple2d4.x - tuple2d3.x) * (tuple2d.y - tuple2d3.y) - (tuple2d4.y - tuple2d3.y) * (tuple2d.x - tuple2d3.x)) / ((tuple2d4.y - tuple2d3.y) * (tuple2d2.x - tuple2d.x) - (tuple2d4.x - tuple2d3.x) * (tuple2d2.y - tuple2d.y));
        double d2 = ((tuple2d2.x - tuple2d.x) * (tuple2d.y - tuple2d3.y) - (tuple2d2.y - tuple2d.y) * (tuple2d.x - tuple2d3.x)) / ((tuple2d4.y - tuple2d3.y) * (tuple2d2.x - tuple2d.x) - (tuple2d4.x - tuple2d3.x) * (tuple2d2.y - tuple2d.y));
        if (d < 0.0 || d > 1.0 || d2 < 0.0 || d2 > 1.0) {
            return null;
        }
        return new Vector2d(tuple2d.x + d * (tuple2d2.x - tuple2d.x), tuple2d3.y + d2 * (tuple2d4.y - tuple2d3.y));
    }

    public static final Vector2d intersectLineSegmentAndLineSegment2D(double d, double d2, double d3, double d4, double d5, double d6, double d7, double d8) {
        double d9 = (d8 - d6) * (d3 - d) - (d7 - d5) * (d4 - d2);
        if (d9 == 0.0) {
            return null;
        }
        double d10 = ((d7 - d5) * (d2 - d6) - (d8 - d6) * (d - d5)) / d9;
        double d11 = ((d3 - d) * (d2 - d6) - (d4 - d2) * (d - d5)) / d9;
        if (d10 < 0.0 || d10 > 1.0 || d11 < 0.0 || d11 > 1.0) {
            return null;
        }
        return new Vector2d(d + d10 * (d3 - d), d6 + d11 * (d8 - d6));
    }

    public static final Vector2d[] intersectLineAndRectangle(Tuple2d tuple2d, Tuple2d tuple2d2, Tuple2d tuple2d3, Tuple2d tuple2d4) {
        double d;
        double d2;
        Vector2d vector2d = new Vector2d(tuple2d2.x - tuple2d.x, tuple2d2.y - tuple2d.y);
        int n = 0;
        Vector2d[] vector2dArray = new Vector2d[4];
        if (vector2d.x != 0.0) {
            d2 = tuple2d3.x;
            d = vector2d.y * (d2 - tuple2d.x) / vector2d.x + tuple2d.y;
            if (d >= tuple2d3.y && d <= tuple2d4.y) {
                vector2dArray[n] = new Vector2d(d2, d);
                ++n;
            }
            if ((d = vector2d.y * ((d2 = tuple2d4.x) - tuple2d.x) / vector2d.x + tuple2d.y) >= tuple2d3.y && d <= tuple2d4.y) {
                vector2dArray[n] = new Vector2d(d2, d);
                ++n;
            }
        }
        if (vector2d.y != 0.0) {
            d2 = tuple2d3.y;
            d = vector2d.x * (d2 - tuple2d.y) / vector2d.y + tuple2d.x;
            if (d >= tuple2d3.x && d <= tuple2d4.x) {
                vector2dArray[n] = new Vector2d(d, d2);
                ++n;
            }
            if ((d = vector2d.x * ((d2 = tuple2d4.y) - tuple2d.y) / vector2d.y + tuple2d.x) >= tuple2d3.x && d <= tuple2d4.x) {
                vector2dArray[n] = new Vector2d(d, d2);
                ++n;
            }
        }
        return vector2dArray;
    }

    public static final double[] extractAngles(Matrix4d matrix4d) {
        double[] dArray = new double[]{Math.atan2(matrix4d.getElement(1, 2), matrix4d.getElement(2, 2)) / Math.PI * 180.0, -Math.asin(matrix4d.getElement(0, 2)) / Math.PI * 180.0, Math.atan2(matrix4d.getElement(0, 1), matrix4d.getElement(0, 0)) / Math.PI * 180.0};
        return dArray;
    }

    public static final void mulRotationalMatrixByZoomVector(Matrix4d matrix4d, Vector4d vector4d) {
        matrix4d.m00 *= vector4d.x;
        matrix4d.m01 *= vector4d.x;
        matrix4d.m02 *= vector4d.x;
        matrix4d.m03 *= vector4d.x;
        matrix4d.m10 *= vector4d.y;
        matrix4d.m11 *= vector4d.y;
        matrix4d.m12 *= vector4d.y;
        matrix4d.m13 *= vector4d.y;
        matrix4d.m20 *= vector4d.z;
        matrix4d.m21 *= vector4d.z;
        matrix4d.m22 *= vector4d.z;
        matrix4d.m23 *= vector4d.z;
        matrix4d.m30 *= vector4d.w;
        matrix4d.m31 *= vector4d.w;
        matrix4d.m32 *= vector4d.w;
        matrix4d.m33 *= vector4d.w;
    }

    public static Point4d restrictToPlane(Point4d point4d, Point3d point3d, Vector3d vector3d) {
        if (vector3d.length() > 0.0) {
            vector3d.normalize();
        }
        double d = vector3d.x;
        double d2 = vector3d.y;
        double d3 = vector3d.z;
        double d4 = -(d * point3d.x + d2 * point3d.y + d3 * point3d.z);
        double d5 = -(d4 / (d * d + d2 * d2 + d3 * d3));
        Vector4d vector4d = new Vector4d(d * d5, d2 * d5, d3 * d5, 0.0);
        point4d.sub((Tuple4d)vector4d);
        double d6 = d2 * d2 + d3 * d3;
        double d7 = -(d * d2);
        double d8 = -(d * d3);
        double d9 = -(d2 * d);
        double d10 = d * d + d3 * d3;
        double d11 = -(d2 * d3);
        double d12 = -(d3 * d);
        double d13 = -(d3 * d2);
        double d14 = d * d + d2 * d2;
        Point4d point4d2 = new Point4d();
        point4d2.x = point4d.x * d6 + point4d.y * d9 + point4d.z * d12;
        point4d2.y = point4d.x * d7 + point4d.y * d10 + point4d.z * d13;
        point4d2.z = point4d.x * d8 + point4d.y * d11 + point4d.z * d14;
        point4d2.w = 1.0;
        point4d2.add((Tuple4d)vector4d);
        return point4d2;
    }

    public static Vector3d getCenterOfGravity(Point3d[] point3dArray) {
        if (point3dArray.length == 0) {
            return null;
        }
        Vector3d vector3d = new Vector3d();
        Point3d[] point3dArray2 = point3dArray;
        int n = point3dArray.length;
        int n2 = 0;
        while (n2 < n) {
            Point3d point3d = point3dArray2[n2];
            vector3d.x += point3d.x;
            vector3d.y += point3d.y;
            vector3d.z += point3d.z;
            ++n2;
        }
        vector3d.x /= (double)point3dArray.length;
        vector3d.y /= (double)point3dArray.length;
        vector3d.z /= (double)point3dArray.length;
        return vector3d;
    }

    public static boolean isParallel(Point3d[] point3dArray, Point3d[] point3dArray2, double d) {
        Vector3d vector3d;
        Vector3d vector3d2 = GeomUtil.getNormalVectorFromPlane(point3dArray);
        return Math.abs(vector3d2.angle(vector3d = GeomUtil.getNormalVectorFromPlane(point3dArray2))) <= d;
    }

    public static boolean isParallel(int n, int n2, int n3, int n4, int n5, int n6, int n7, int n8, double d) {
        double d2 = n4 - n2;
        double d3 = n3 - n;
        Vector2d vector2d = new Vector2d(-d2, d3);
        double d4 = n8 - n6;
        double d5 = n7 - n5;
        Vector2d vector2d2 = new Vector2d(-d4, d5);
        return Math.abs(vector2d.angle(vector2d2)) <= d;
    }

    public static double getPerpendicularPositionOnLine(int n, int n2, int n3, int n4, int n5, int n6) {
        Vector2d vector2d = new Vector2d((double)(n - n5), (double)(n2 - n6));
        Vector2d vector2d2 = new Vector2d((double)(n - n3), (double)(n2 - n4));
        double d = vector2d.dot(vector2d2) / vector2d2.lengthSquared();
        return d;
    }

    public static Vector3d getNormalVectorFromPlane(Point3d[] point3dArray) {
        if (point3dArray.length < 3) {
            return null;
        }
        int n = point3dArray.length > 3 ? 3 : 2;
        Vector3d vector3d = new Vector3d((Tuple3d)point3dArray[1]);
        vector3d.sub((Tuple3d)point3dArray[0]);
        Vector3d vector3d2 = new Vector3d((Tuple3d)point3dArray[n]);
        vector3d2.sub((Tuple3d)point3dArray[0]);
        Vector3d vector3d3 = new Vector3d();
        vector3d3.cross(vector3d, vector3d2);
        return vector3d3;
    }

    public static double getDistancePointToSegment(Point3d point3d, Point3d point3d2, Point3d point3d3) {
        double d = point3d2.x - point3d.x;
        double d2 = point3d2.y - point3d.y;
        double d3 = point3d2.z - point3d.z;
        if (d == 0.0 && d2 == 0.0 && d3 == 0.0) {
            throw new IllegalArgumentException("p1 and p2 cannot be the same point");
        }
        double d4 = ((point3d3.x - point3d.x) * d + (point3d3.y - point3d.y) * d2 + (point3d3.z - point3d.z) * d3) / (d * d + d2 * d2 + d3 * d3);
        Point3d point3d4 = d4 < 0.0 ? point3d : (d4 > 1.0 ? point3d2 : new Point3d(point3d.x + d4 * d, point3d.y + d4 * d2, point3d.z + d4 * d3));
        return point3d4.distance(point3d3);
    }

    public static boolean isZeroMatrix(Matrix4d matrix4d) {
        return matrix4d.m00 == 0.0 && matrix4d.m01 == 0.0 && matrix4d.m02 == 0.0 && matrix4d.m03 == 0.0 && matrix4d.m10 == 0.0 && matrix4d.m11 == 0.0 && matrix4d.m12 == 0.0 && matrix4d.m13 == 0.0 && matrix4d.m20 == 0.0 && matrix4d.m21 == 0.0 && matrix4d.m22 == 0.0 && matrix4d.m23 == 0.0 && matrix4d.m30 == 0.0 && matrix4d.m31 == 0.0 && matrix4d.m32 == 0.0 && matrix4d.m33 == 0.0;
    }

    public static double interpolate(double d, double d2, double d3) {
        double d4 = d2 - d;
        return d + d4 * d3;
    }
}

