/*
 * Decompiled with CFR 0.152.
 */
package com.agfa.hap.geometry.impl.twod;

import com.agfa.hap.geometry.api.twod.IConvexPolygon2d;
import com.agfa.hap.geometry.impl.twod.Line2d;
import com.agfa.hap.geometry.impl.twod.PolarPoint2d;
import com.agfa.hap.geometry.impl.twod.Polygon2d;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.vecmath.Point2d;

public class ConvexPolygon2d
extends Polygon2d
implements IConvexPolygon2d {
    private Point2d centre = null;
    private Double area;

    public ConvexPolygon2d(List<Point2d> list) {
        super(list);
        this.sortPoints();
    }

    protected ConvexPolygon2d() {
    }

    @Override
    public double getArea() {
        if (this.area == null) {
            this.area = this.computeArea();
        }
        return this.area;
    }

    private Double computeArea() {
        Point2d point2d = this.getCentre();
        int n = this.points.size();
        double d = 0.0;
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 % n;
            int n4 = (n2 + 1) % n;
            d += this.triangleArea((Point2d)this.points.get(n3), (Point2d)this.points.get(n4), point2d);
            ++n2;
        }
        return new Double(d);
    }

    @Override
    public Point2d getCentre() {
        if (this.centre == null) {
            this.centre = this.computeCentre();
        }
        return this.centre;
    }

    private Point2d computeCentre() {
        double d = 0.0;
        double d2 = 0.0;
        double d3 = 0.0;
        for (Point2d point2d : this.points) {
            d += point2d.x;
            d2 += point2d.y;
            d3 += 1.0;
        }
        return new Point2d(d / d3, d2 / d3);
    }

    private double triangleArea(Point2d point2d, Point2d point2d2, Point2d point2d3) {
        return Math.abs((point2d.getX() - point2d3.getX()) * (point2d2.getY() - point2d.getY()) - (point2d.getX() - point2d2.getX()) * (point2d3.getY() - point2d.getY())) * 0.5;
    }

    @Override
    public boolean isInside(Point2d point2d) {
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 % n;
            int n4 = (n2 + 1) % n;
            Line2d line2d = new Line2d((Point2d)this.points.get(n3), (Point2d)this.points.get(n4), true);
            double d = line2d.distanceToPoint(point2d);
            if (d > 0.0) {
                return false;
            }
            ++n2;
        }
        return true;
    }

    private void sortPoints() {
        Point2d point2d = this.getCentre();
        ArrayList<PolarPoint2d> arrayList = new ArrayList<PolarPoint2d>(this.points.size());
        for (Point2d object : this.points) {
            arrayList.add(new PolarPoint2d(object, point2d));
        }
        Collections.sort(arrayList);
        this.points = new ArrayList(arrayList.size());
        for (PolarPoint2d polarPoint2d : arrayList) {
            this.points.add(polarPoint2d.cartesian);
        }
    }

    @Override
    public IConvexPolygon2d intersect(IConvexPolygon2d iConvexPolygon2d) {
        Object object2;
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        List<Point2d> list = this.intersectPoints(iConvexPolygon2d);
        if (list != null) {
            arrayList.addAll(list);
        }
        for (Object object2 : this.points) {
            if (!iConvexPolygon2d.isInside((Point2d)object2)) continue;
            arrayList.add((Point2d)object2);
        }
        for (Object object2 : iConvexPolygon2d.getPoints()) {
            if (!this.isInside((Point2d)object2)) continue;
            arrayList.add((Point2d)object2);
        }
        if (arrayList.size() <= 0) {
            return null;
        }
        object2 = new ConvexPolygon2d(arrayList);
        return object2;
    }

    private List<Point2d> intersectPoints(IConvexPolygon2d iConvexPolygon2d) {
        ArrayList<Point2d> arrayList = new ArrayList<Point2d>();
        int n = this.points.size();
        int n2 = 0;
        while (n2 < n) {
            int n3 = n2 % n;
            int n4 = (n2 + 1) % n;
            Line2d line2d = new Line2d((Point2d)this.points.get(n3), (Point2d)this.points.get(n4), true);
            List<Point2d> list = iConvexPolygon2d.intersect(line2d);
            if (list != null) {
                arrayList.addAll(list);
            }
            ++n2;
        }
        if (arrayList.size() > 0) {
            return arrayList;
        }
        return null;
    }
}

